/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import org.apache.sedona.sql.datasources.osmpbf.TruncatedStream;
import org.apache.sedona.sql.datasources.osmpbf.build.Fileformat;
import org.apache.sedona.sql.datasources.osmpbf.iterators.BlobData;

public class PrimitiveGroupIterator
implements Iterator<BlobData> {
    TruncatedStream pbfInputStream;
    DataInputStream pbfStream;
    int nextHeaderSize;

    public PrimitiveGroupIterator(TruncatedStream pbfInputStream) {
        this.pbfInputStream = pbfInputStream;
        this.pbfStream = new DataInputStream(pbfInputStream);
        this.nextHeaderSize = -1;
        this.readNextBlockLength();
    }

    @Override
    public boolean hasNext() {
        return this.pbfInputStream.continueReading() && this.nextHeaderSize != -1;
    }

    @Override
    public BlobData next() {
        try {
            byte[] bufferBlobHeader = new byte[this.nextHeaderSize];
            this.pbfStream.readFully(bufferBlobHeader);
            Fileformat.BlobHeader blobHeader = Fileformat.BlobHeader.parseFrom(bufferBlobHeader);
            byte[] bufferBlob = new byte[blobHeader.getDatasize()];
            this.pbfStream.readFully(bufferBlob);
            Fileformat.Blob blob = Fileformat.Blob.parseFrom(bufferBlob);
            this.readNextBlockLength();
            return new BlobData(blobHeader, blob);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readNextBlockLength() {
        try {
            this.nextHeaderSize = this.pbfStream.readInt();
        }
        catch (EOFException e) {
            this.nextHeaderSize = -1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

