/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.vecmath.Point2d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Machine;
import org.twak.camp.Skeleton;
import org.twak.camp.debug.DebugDevice;
import org.twak.camp.debug.SkeletonPointEditor;
import org.twak.camp.ui.Bar;
import org.twak.utils.Cache;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;

public class OffsetPointEditor
extends SkeletonPointEditor {
    @Override
    public void paintPointEditor(Graphics2D g2) {
        g2.setColor(Color.red);
        for (Loop loop : this.edges) {
            for (Bar bar : loop) {
                g2.drawLine(this.ma.toX(bar.start.x), this.ma.toY(bar.start.y), this.ma.toX(bar.end.x), this.ma.toY(bar.end.y));
            }
            g2.setColor(Color.orange);
        }
        for (Bar bar : this.edges.eIterator()) {
            this.drawPixel((Graphics)g2, bar.start);
        }
        final LoopL out = new LoopL();
        Cache<Point2d, Corner> cCache = new Cache<Point2d, Corner>(){

            @Override
            public Corner create(Point2d i) {
                return new Corner(i.x, i.y);
            }
        };
        Machine machineO = new Machine(0.7853981633974483);
        for (Loop lb : this.edges) {
            Loop<Corner> loop = new Loop<Corner>();
            out.add(loop);
            for (Bar bar : lb) {
                Corner s2 = (Corner)cCache.get(bar.start);
                Corner e = (Corner)cCache.get(bar.end);
                e.prevL = s2.nextL = new Edge(s2, e);
                s2.nextC = e;
                e.prevC = s2;
                s2.nextL.machine = machineO;
                loop.append(s2);
            }
        }
        if (!this.busy && this.changed) {
            this.busy = true;
            this.changed = false;
            new Thread(){

                @Override
                public void run() {
                    try {
                        DebugDevice.reset();
                        Skeleton skeleton = new Skeleton(out, 50.0, true);
                        skeleton.skeleton();
                        OffsetPointEditor.this.output = skeleton.output;
                    }
                    finally {
                        OffsetPointEditor.this.busy = false;
                        OffsetPointEditor.this.repaint();
                    }
                }
            }.start();
        }
        this.paintMultiColourOutput(g2);
    }
}

