/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.GeometryFunctions;
import org.apache.sedona.common.utils.CachedCRSTransformFinder;
import org.apache.sedona.common.utils.GeomUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;

public class RasterPredicates {
    public static boolean rsIntersects(GridCoverage2D raster, Geometry geometry) {
        Pair<Geometry, Geometry> geometries = RasterPredicates.convertCRSIfNeeded(raster, geometry);
        Geometry rasterGeometry = (Geometry)geometries.getLeft();
        Geometry queryWindow = (Geometry)geometries.getRight();
        return rasterGeometry.intersects(queryWindow);
    }

    public static boolean rsContains(GridCoverage2D raster, Geometry geometry) {
        Pair<Geometry, Geometry> geometries = RasterPredicates.convertCRSIfNeeded(raster, geometry);
        Geometry rasterGeometry = (Geometry)geometries.getLeft();
        Geometry queryWindow = (Geometry)geometries.getRight();
        return rasterGeometry.contains(queryWindow);
    }

    public static boolean rsWithin(GridCoverage2D raster, Geometry geometry) {
        Pair<Geometry, Geometry> geometries = RasterPredicates.convertCRSIfNeeded(raster, geometry);
        Geometry rasterGeometry = (Geometry)geometries.getLeft();
        Geometry queryWindow = (Geometry)geometries.getRight();
        return rasterGeometry.within(queryWindow);
    }

    public static boolean rsIntersects(GridCoverage2D left, GridCoverage2D right) {
        Pair<Geometry, Geometry> geometries = RasterPredicates.convertCRSIfNeeded(left, right);
        Geometry leftGeometry = (Geometry)geometries.getLeft();
        Geometry rightGeometry = (Geometry)geometries.getRight();
        return leftGeometry.intersects(rightGeometry);
    }

    public static boolean rsContains(GridCoverage2D left, GridCoverage2D right) {
        Pair<Geometry, Geometry> geometries = RasterPredicates.convertCRSIfNeeded(left, right);
        Geometry leftGeometry = (Geometry)geometries.getLeft();
        Geometry rightGeometry = (Geometry)geometries.getRight();
        return leftGeometry.contains(rightGeometry);
    }

    private static Pair<Geometry, Geometry> convertCRSIfNeeded(GridCoverage2D raster, Geometry queryWindow) {
        int queryWindowSRID;
        Geometry rasterGeometry;
        try {
            rasterGeometry = GeometryFunctions.convexHull(raster);
        }
        catch (FactoryException | TransformException e) {
            throw new RuntimeException("Failed to calculate the convex hull of the raster", e);
        }
        CoordinateReferenceSystem rasterCRS = raster.getCoordinateReferenceSystem();
        if (rasterCRS == null || rasterCRS instanceof DefaultEngineeringCRS) {
            rasterCRS = DefaultGeographicCRS.WGS84;
        }
        if ((queryWindowSRID = queryWindow.getSRID()) <= 0) {
            queryWindowSRID = 4326;
        }
        if (RasterPredicates.isCRSMatchesSRID(rasterCRS, queryWindowSRID)) {
            return Pair.of((Object)rasterGeometry, (Object)queryWindow);
        }
        CoordinateReferenceSystem queryWindowCRS = FunctionsGeoTools.sridToCRS(queryWindowSRID);
        Geometry transformedQueryWindow = RasterPredicates.transformGeometryToWGS84(queryWindow, queryWindowCRS);
        Geometry transformedRasterGeometry = RasterPredicates.transformGeometryToWGS84(rasterGeometry, rasterCRS);
        return Pair.of((Object)transformedRasterGeometry, (Object)transformedQueryWindow);
    }

    private static Pair<Geometry, Geometry> convertCRSIfNeeded(GridCoverage2D left, GridCoverage2D right) {
        CoordinateReferenceSystem rightCRS;
        Geometry rightGeometry;
        Geometry leftGeometry;
        try {
            leftGeometry = GeometryFunctions.convexHull(left);
            rightGeometry = GeometryFunctions.convexHull(right);
        }
        catch (FactoryException | TransformException e) {
            throw new RuntimeException("Failed to calculate the convex hull of the raster", e);
        }
        CoordinateReferenceSystem leftCRS = left.getCoordinateReferenceSystem();
        if (leftCRS == null || leftCRS instanceof DefaultEngineeringCRS) {
            leftCRS = DefaultGeographicCRS.WGS84;
        }
        if ((rightCRS = right.getCoordinateReferenceSystem()) == null || rightCRS instanceof DefaultEngineeringCRS) {
            rightCRS = DefaultGeographicCRS.WGS84;
        }
        if (leftCRS == rightCRS || CRS.equalsIgnoreMetadata((Object)leftCRS, (Object)rightCRS)) {
            return Pair.of((Object)leftGeometry, (Object)rightGeometry);
        }
        Geometry transformedLeftGeometry = RasterPredicates.transformGeometryToWGS84(leftGeometry, leftCRS);
        Geometry transformedRightGeometry = RasterPredicates.transformGeometryToWGS84(rightGeometry, rightCRS);
        return Pair.of((Object)transformedLeftGeometry, (Object)transformedRightGeometry);
    }

    public static boolean isCRSMatchesSRID(CoordinateReferenceSystem crs, int srid) {
        CRS.AxisOrder axisOrder = CRS.getAxisOrder((CoordinateReferenceSystem)crs);
        if (axisOrder == CRS.AxisOrder.NORTH_EAST) {
            return false;
        }
        Set crsIds = crs.getIdentifiers();
        String strSrid = String.valueOf(srid);
        for (ReferenceIdentifier crsId : crsIds) {
            if (!"EPSG".equals(crsId.getCodeSpace()) || !strSrid.equals(crsId.getCode())) continue;
            return true;
        }
        return false;
    }

    private static Geometry transformGeometryToWGS84(Geometry geometry, CoordinateReferenceSystem crs) {
        if (crs == DefaultGeographicCRS.WGS84) {
            return geometry;
        }
        try {
            MathTransform transform = CachedCRSTransformFinder.findTransform(crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            Geometry transformedGeometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
            if (!(crs instanceof GeographicCRS)) {
                transformedGeometry = GeomUtils.antiMeridianSafeGeom(transformedGeometry);
            }
            return transformedGeometry;
        }
        catch (TransformException e) {
            throw new RuntimeException("Cannot transform CRS for evaluating predicate", e);
        }
    }
}

