/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class EigenvalueDecomposition
implements Serializable {
    private int n;
    private boolean issymmetric;
    private double[] d;
    private double[] e;
    private double[][] V;
    private double[][] H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;
    private static final long serialVersionUID = 1L;

    private void tred2() {
        double d;
        int n;
        for (n = 0; n < this.n; ++n) {
            this.d[n] = this.V[this.n - 1][n];
        }
        for (n = this.n - 1; n > 0; --n) {
            int n2;
            d = 0.0;
            double d2 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += Math.abs(this.d[n2]);
            }
            if (d == 0.0) {
                this.e[n] = this.d[n - 1];
                for (n2 = 0; n2 < n; ++n2) {
                    this.d[n2] = this.V[n - 1][n2];
                    this.V[n][n2] = 0.0;
                    this.V[n2][n] = 0.0;
                }
            } else {
                int n3;
                int n4;
                for (n2 = 0; n2 < n; ++n2) {
                    int n5 = n2;
                    this.d[n5] = this.d[n5] / d;
                    d2 += this.d[n2] * this.d[n2];
                }
                double d3 = this.d[n - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                this.e[n] = d * d4;
                d2 -= d3 * d4;
                this.d[n - 1] = d3 - d4;
                for (n4 = 0; n4 < n; ++n4) {
                    this.e[n4] = 0.0;
                }
                for (n4 = 0; n4 < n; ++n4) {
                    this.V[n4][n] = d3 = this.d[n4];
                    d4 = this.e[n4] + this.V[n4][n4] * d3;
                    for (int i = n4 + 1; i <= n - 1; ++i) {
                        d4 += this.V[i][n4] * this.d[i];
                        int n6 = i;
                        this.e[n6] = this.e[n6] + this.V[i][n4] * d3;
                    }
                    this.e[n4] = d4;
                }
                d3 = 0.0;
                for (n4 = 0; n4 < n; ++n4) {
                    int n7 = n4;
                    this.e[n7] = this.e[n7] / d2;
                    d3 += this.e[n4] * this.d[n4];
                }
                double d5 = d3 / (d2 + d2);
                for (n3 = 0; n3 < n; ++n3) {
                    int n8 = n3;
                    this.e[n8] = this.e[n8] - d5 * this.d[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    d3 = this.d[n3];
                    d4 = this.e[n3];
                    for (int i = n3; i <= n - 1; ++i) {
                        double[] dArray = this.V[i];
                        int n9 = n3;
                        dArray[n9] = dArray[n9] - (d3 * this.e[i] + d4 * this.d[i]);
                    }
                    this.d[n3] = this.V[n - 1][n3];
                    this.V[n][n3] = 0.0;
                }
            }
            this.d[n] = d2;
        }
        for (n = 0; n < this.n - 1; ++n) {
            int n10;
            this.V[this.n - 1][n] = this.V[n][n];
            this.V[n][n] = 1.0;
            d = this.d[n + 1];
            if (d != 0.0) {
                for (n10 = 0; n10 <= n; ++n10) {
                    this.d[n10] = this.V[n10][n + 1] / d;
                }
                for (n10 = 0; n10 <= n; ++n10) {
                    int n11;
                    double d6 = 0.0;
                    for (n11 = 0; n11 <= n; ++n11) {
                        d6 += this.V[n11][n + 1] * this.V[n11][n10];
                    }
                    for (n11 = 0; n11 <= n; ++n11) {
                        double[] dArray = this.V[n11];
                        int n12 = n10;
                        dArray[n12] = dArray[n12] - d6 * this.d[n11];
                    }
                }
            }
            for (n10 = 0; n10 <= n; ++n10) {
                this.V[n10][n + 1] = 0.0;
            }
        }
        for (n = 0; n < this.n; ++n) {
            this.d[n] = this.V[this.n - 1][n];
            this.V[this.n - 1][n] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        int n;
        int n2;
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.pow(2.0, -52.0);
        for (n2 = 0; n2 < this.n; ++n2) {
            d2 = Math.max(d2, Math.abs(this.d[n2]) + Math.abs(this.e[n2]));
            for (n = n2; n < this.n && !(Math.abs(this.e[n]) <= d3 * d2); ++n) {
            }
            if (n > n2) {
                int n3 = 0;
                do {
                    double d4;
                    ++n3;
                    double d5 = this.d[n2];
                    double d6 = (this.d[n2 + 1] - d5) / (2.0 * this.e[n2]);
                    double d7 = Maths.hypot(d6, 1.0);
                    if (d6 < 0.0) {
                        d7 = -d7;
                    }
                    this.d[n2] = this.e[n2] / (d6 + d7);
                    this.d[n2 + 1] = this.e[n2] * (d6 + d7);
                    double d8 = this.d[n2 + 1];
                    double d9 = d5 - this.d[n2];
                    int n4 = n2 + 2;
                    while (n4 < this.n) {
                        int n5 = n4++;
                        this.d[n5] = this.d[n5] - d9;
                    }
                    d += d9;
                    d6 = this.d[n];
                    double d10 = d4 = 1.0;
                    double d11 = d4;
                    double d12 = this.e[n2 + 1];
                    double d13 = 0.0;
                    double d14 = 0.0;
                    for (int i = n - 1; i >= n2; --i) {
                        d11 = d10;
                        d10 = d4;
                        d14 = d13;
                        d5 = d4 * this.e[i];
                        d9 = d4 * d6;
                        d7 = Maths.hypot(d6, this.e[i]);
                        this.e[i + 1] = d13 * d7;
                        d13 = this.e[i] / d7;
                        d4 = d6 / d7;
                        d6 = d4 * this.d[i] - d13 * d5;
                        this.d[i + 1] = d9 + d13 * (d4 * d5 + d13 * this.d[i]);
                        for (int j = 0; j < this.n; ++j) {
                            d9 = this.V[j][i + 1];
                            this.V[j][i + 1] = d13 * this.V[j][i] + d4 * d9;
                            this.V[j][i] = d4 * this.V[j][i] - d13 * d9;
                        }
                    }
                    d6 = -d13 * d14 * d11 * d12 * this.e[n2] / d8;
                    this.e[n2] = d13 * d6;
                    this.d[n2] = d4 * d6;
                } while (Math.abs(this.e[n2]) > d3 * d2);
            }
            this.d[n2] = this.d[n2] + d;
            this.e[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.n - 1; ++n2) {
            int n6;
            n = n2;
            double d15 = this.d[n2];
            for (n6 = n2 + 1; n6 < this.n; ++n6) {
                if (!(this.d[n6] < d15)) continue;
                n = n6;
                d15 = this.d[n6];
            }
            if (n == n2) continue;
            this.d[n] = this.d[n2];
            this.d[n2] = d15;
            for (n6 = 0; n6 < this.n; ++n6) {
                d15 = this.V[n6][n2];
                this.V[n6][n2] = this.V[n6][n];
                this.V[n6][n] = d15;
            }
        }
    }

    private void orthes() {
        int n;
        int n2 = 0;
        int n3 = this.n - 1;
        for (n = n2 + 1; n <= n3 - 1; ++n) {
            int n4;
            double d;
            int n5;
            double d2 = 0.0;
            for (int i = n; i <= n3; ++i) {
                d2 += Math.abs(this.H[i][n - 1]);
            }
            if (d2 == 0.0) continue;
            double d3 = 0.0;
            for (int i = n3; i >= n; --i) {
                this.ort[i] = this.H[i][n - 1] / d2;
                d3 += this.ort[i] * this.ort[i];
            }
            double d4 = Math.sqrt(d3);
            if (this.ort[n] > 0.0) {
                d4 = -d4;
            }
            d3 -= this.ort[n] * d4;
            this.ort[n] = this.ort[n] - d4;
            for (n5 = n; n5 < this.n; ++n5) {
                d = 0.0;
                for (n4 = n3; n4 >= n; --n4) {
                    d += this.ort[n4] * this.H[n4][n5];
                }
                d /= d3;
                for (n4 = n; n4 <= n3; ++n4) {
                    double[] dArray = this.H[n4];
                    int n6 = n5;
                    dArray[n6] = dArray[n6] - d * this.ort[n4];
                }
            }
            for (n5 = 0; n5 <= n3; ++n5) {
                d = 0.0;
                for (n4 = n3; n4 >= n; --n4) {
                    d += this.ort[n4] * this.H[n5][n4];
                }
                d /= d3;
                for (n4 = n; n4 <= n3; ++n4) {
                    double[] dArray = this.H[n5];
                    int n7 = n4;
                    dArray[n7] = dArray[n7] - d * this.ort[n4];
                }
            }
            this.ort[n] = d2 * this.ort[n];
            this.H[n][n - 1] = d2 * d4;
        }
        for (n = 0; n < this.n; ++n) {
            for (int i = 0; i < this.n; ++i) {
                this.V[n][i] = n == i ? 1.0 : 0.0;
            }
        }
        for (n = n3 - 1; n >= n2 + 1; --n) {
            int n8;
            if (this.H[n][n - 1] == 0.0) continue;
            for (n8 = n + 1; n8 <= n3; ++n8) {
                this.ort[n8] = this.H[n8][n - 1];
            }
            for (n8 = n; n8 <= n3; ++n8) {
                int n9;
                double d = 0.0;
                for (n9 = n; n9 <= n3; ++n9) {
                    d += this.ort[n9] * this.V[n9][n8];
                }
                d = d / this.ort[n] / this.H[n][n - 1];
                for (n9 = n; n9 <= n3; ++n9) {
                    double[] dArray = this.V[n9];
                    int n10 = n8;
                    dArray[n10] = dArray[n10] + d * this.ort[n9];
                }
            }
        }
    }

    private void cdiv(double d, double d2, double d3, double d4) {
        if (Math.abs(d3) > Math.abs(d4)) {
            double d5 = d4 / d3;
            double d6 = d3 + d5 * d4;
            this.cdivr = (d + d5 * d2) / d6;
            this.cdivi = (d2 - d5 * d) / d6;
        } else {
            double d7 = d3 / d4;
            double d8 = d4 + d7 * d3;
            this.cdivr = (d7 * d + d2) / d8;
            this.cdivi = (d7 * d2 - d) / d8;
        }
    }

    private void hqr2() {
        double d;
        int n;
        double d2;
        double d3;
        int n2;
        int n3;
        int n4 = this.n;
        int n5 = n4 - 1;
        int n6 = 0;
        int n7 = n4 - 1;
        double d4 = Math.pow(2.0, -52.0);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 < n6 | n3 > n7) {
                this.d[n3] = this.H[n3][n3];
                this.e[n3] = 0.0;
            }
            for (n2 = Math.max(n3 - 1, 0); n2 < n4; ++n2) {
                d11 += Math.abs(this.H[n3][n2]);
            }
        }
        n3 = 0;
        while (n5 >= n6) {
            int n8;
            for (n2 = n5; n2 > n6; --n2) {
                d9 = Math.abs(this.H[n2 - 1][n2 - 1]) + Math.abs(this.H[n2][n2]);
                if (d9 == 0.0) {
                    d9 = d11;
                }
                if (Math.abs(this.H[n2][n2 - 1]) < d4 * d9) break;
            }
            if (n2 == n5) {
                this.H[n5][n5] = this.H[n5][n5] + d5;
                this.d[n5] = this.H[n5][n5];
                this.e[n5] = 0.0;
                --n5;
                n3 = 0;
                continue;
            }
            if (n2 == n5 - 1) {
                d3 = this.H[n5][n5 - 1] * this.H[n5 - 1][n5];
                d6 = (this.H[n5 - 1][n5 - 1] - this.H[n5][n5]) / 2.0;
                d7 = d6 * d6 + d3;
                d10 = Math.sqrt(Math.abs(d7));
                this.H[n5][n5] = this.H[n5][n5] + d5;
                this.H[n5 - 1][n5 - 1] = this.H[n5 - 1][n5 - 1] + d5;
                d2 = this.H[n5][n5];
                if (d7 >= 0.0) {
                    d10 = d6 >= 0.0 ? d6 + d10 : d6 - d10;
                    this.d[n5 - 1] = d2 + d10;
                    this.d[n5] = this.d[n5 - 1];
                    if (d10 != 0.0) {
                        this.d[n5] = d2 - d3 / d10;
                    }
                    this.e[n5 - 1] = 0.0;
                    this.e[n5] = 0.0;
                    d2 = this.H[n5][n5 - 1];
                    d9 = Math.abs(d2) + Math.abs(d10);
                    d6 = d2 / d9;
                    d7 = d10 / d9;
                    d8 = Math.sqrt(d6 * d6 + d7 * d7);
                    d6 /= d8;
                    d7 /= d8;
                    for (n = n5 - 1; n < n4; ++n) {
                        d10 = this.H[n5 - 1][n];
                        this.H[n5 - 1][n] = d7 * d10 + d6 * this.H[n5][n];
                        this.H[n5][n] = d7 * this.H[n5][n] - d6 * d10;
                    }
                    for (n = 0; n <= n5; ++n) {
                        d10 = this.H[n][n5 - 1];
                        this.H[n][n5 - 1] = d7 * d10 + d6 * this.H[n][n5];
                        this.H[n][n5] = d7 * this.H[n][n5] - d6 * d10;
                    }
                    for (n = n6; n <= n7; ++n) {
                        d10 = this.V[n][n5 - 1];
                        this.V[n][n5 - 1] = d7 * d10 + d6 * this.V[n][n5];
                        this.V[n][n5] = d7 * this.V[n][n5] - d6 * d10;
                    }
                } else {
                    this.d[n5 - 1] = d2 + d6;
                    this.d[n5] = d2 + d6;
                    this.e[n5 - 1] = d10;
                    this.e[n5] = -d10;
                }
                n5 -= 2;
                n3 = 0;
                continue;
            }
            d2 = this.H[n5][n5];
            d = 0.0;
            d3 = 0.0;
            if (n2 < n5) {
                d = this.H[n5 - 1][n5 - 1];
                d3 = this.H[n5][n5 - 1] * this.H[n5 - 1][n5];
            }
            if (n3 == 10) {
                d5 += d2;
                n = n6;
                while (n <= n5) {
                    double[] dArray = this.H[n];
                    int n9 = n++;
                    dArray[n9] = dArray[n9] - d2;
                }
                d9 = Math.abs(this.H[n5][n5 - 1]) + Math.abs(this.H[n5 - 1][n5 - 2]);
                d2 = d = 0.75 * d9;
                d3 = -0.4375 * d9 * d9;
            }
            if (n3 == 30) {
                d9 = (d - d2) / 2.0;
                if ((d9 = d9 * d9 + d3) > 0.0) {
                    d9 = Math.sqrt(d9);
                    if (d < d2) {
                        d9 = -d9;
                    }
                    d9 = d2 - d3 / ((d - d2) / 2.0 + d9);
                    n = n6;
                    while (n <= n5) {
                        double[] dArray = this.H[n];
                        int n10 = n++;
                        dArray[n10] = dArray[n10] - d9;
                    }
                    d5 += d9;
                    d3 = 0.964;
                    d = 0.964;
                    d2 = 0.964;
                }
            }
            ++n3;
            for (n = n5 - 2; n >= n2; --n) {
                d10 = this.H[n][n];
                d8 = d2 - d10;
                d9 = d - d10;
                d6 = (d8 * d9 - d3) / this.H[n + 1][n] + this.H[n][n + 1];
                d7 = this.H[n + 1][n + 1] - d10 - d8 - d9;
                d8 = this.H[n + 2][n + 1];
                d9 = Math.abs(d6) + Math.abs(d7) + Math.abs(d8);
                if (n == n2 || Math.abs(this.H[n][n - 1]) * (Math.abs(d7 /= d9) + Math.abs(d8 /= d9)) < d4 * (Math.abs(d6 /= d9) * (Math.abs(this.H[n - 1][n - 1]) + Math.abs(d10) + Math.abs(this.H[n + 1][n + 1])))) break;
            }
            for (n8 = n + 2; n8 <= n5; ++n8) {
                this.H[n8][n8 - 2] = 0.0;
                if (n8 <= n + 2) continue;
                this.H[n8][n8 - 3] = 0.0;
            }
            for (n8 = n; n8 <= n5 - 1; ++n8) {
                int n11;
                boolean bl;
                boolean bl2 = bl = n8 != n5 - 1;
                if (n8 != n) {
                    d6 = this.H[n8][n8 - 1];
                    d7 = this.H[n8 + 1][n8 - 1];
                    d8 = bl ? this.H[n8 + 2][n8 - 1] : 0.0;
                    d2 = Math.abs(d6) + Math.abs(d7) + Math.abs(d8);
                    if (d2 == 0.0) continue;
                    d6 /= d2;
                    d7 /= d2;
                    d8 /= d2;
                }
                d9 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8);
                if (d6 < 0.0) {
                    d9 = -d9;
                }
                if (d9 == 0.0) continue;
                if (n8 != n) {
                    this.H[n8][n8 - 1] = -d9 * d2;
                } else if (n2 != n) {
                    this.H[n8][n8 - 1] = -this.H[n8][n8 - 1];
                }
                d2 = (d6 += d9) / d9;
                d = d7 / d9;
                d10 = d8 / d9;
                d7 /= d6;
                d8 /= d6;
                for (n11 = n8; n11 < n4; ++n11) {
                    d6 = this.H[n8][n11] + d7 * this.H[n8 + 1][n11];
                    if (bl) {
                        this.H[n8 + 2][n11] = this.H[n8 + 2][n11] - (d6 += d8 * this.H[n8 + 2][n11]) * d10;
                    }
                    this.H[n8][n11] = this.H[n8][n11] - d6 * d2;
                    this.H[n8 + 1][n11] = this.H[n8 + 1][n11] - d6 * d;
                }
                for (n11 = 0; n11 <= Math.min(n5, n8 + 3); ++n11) {
                    d6 = d2 * this.H[n11][n8] + d * this.H[n11][n8 + 1];
                    if (bl) {
                        this.H[n11][n8 + 2] = this.H[n11][n8 + 2] - (d6 += d10 * this.H[n11][n8 + 2]) * d8;
                    }
                    this.H[n11][n8] = this.H[n11][n8] - d6;
                    this.H[n11][n8 + 1] = this.H[n11][n8 + 1] - d6 * d7;
                }
                for (n11 = n6; n11 <= n7; ++n11) {
                    d6 = d2 * this.V[n11][n8] + d * this.V[n11][n8 + 1];
                    if (bl) {
                        this.V[n11][n8 + 2] = this.V[n11][n8 + 2] - (d6 += d10 * this.V[n11][n8 + 2]) * d8;
                    }
                    this.V[n11][n8] = this.V[n11][n8] - d6;
                    this.V[n11][n8 + 1] = this.V[n11][n8 + 1] - d6 * d7;
                }
            }
        }
        if (d11 == 0.0) {
            return;
        }
        for (n5 = n4 - 1; n5 >= 0; --n5) {
            double d12;
            d6 = this.d[n5];
            d7 = this.e[n5];
            if (d7 == 0.0) {
                n2 = n5;
                this.H[n5][n5] = 1.0;
                for (n = n5 - 1; n >= 0; --n) {
                    int n12;
                    d3 = this.H[n][n] - d6;
                    d8 = 0.0;
                    for (n12 = n2; n12 <= n5; ++n12) {
                        d8 += this.H[n][n12] * this.H[n12][n5];
                    }
                    if (this.e[n] < 0.0) {
                        d10 = d3;
                        d9 = d8;
                        continue;
                    }
                    n2 = n;
                    if (this.e[n] == 0.0) {
                        this.H[n][n5] = d3 != 0.0 ? -d8 / d3 : -d8 / (d4 * d11);
                    } else {
                        d2 = this.H[n][n + 1];
                        d = this.H[n + 1][n];
                        d7 = (this.d[n] - d6) * (this.d[n] - d6) + this.e[n] * this.e[n];
                        this.H[n][n5] = d12 = (d2 * d9 - d10 * d8) / d7;
                        this.H[n + 1][n5] = Math.abs(d2) > Math.abs(d10) ? (-d8 - d3 * d12) / d2 : (-d9 - d * d12) / d10;
                    }
                    d12 = Math.abs(this.H[n][n5]);
                    if (!(d4 * d12 * d12 > 1.0)) continue;
                    for (n12 = n; n12 <= n5; ++n12) {
                        this.H[n12][n5] = this.H[n12][n5] / d12;
                    }
                }
                continue;
            }
            if (!(d7 < 0.0)) continue;
            n2 = n5 - 1;
            if (Math.abs(this.H[n5][n5 - 1]) > Math.abs(this.H[n5 - 1][n5])) {
                this.H[n5 - 1][n5 - 1] = d7 / this.H[n5][n5 - 1];
                this.H[n5 - 1][n5] = -(this.H[n5][n5] - d6) / this.H[n5][n5 - 1];
            } else {
                this.cdiv(0.0, -this.H[n5 - 1][n5], this.H[n5 - 1][n5 - 1] - d6, d7);
                this.H[n5 - 1][n5 - 1] = this.cdivr;
                this.H[n5 - 1][n5] = this.cdivi;
            }
            this.H[n5][n5 - 1] = 0.0;
            this.H[n5][n5] = 1.0;
            for (n = n5 - 2; n >= 0; --n) {
                int n13;
                double d13 = 0.0;
                double d14 = 0.0;
                for (n13 = n2; n13 <= n5; ++n13) {
                    d13 += this.H[n][n13] * this.H[n13][n5 - 1];
                    d14 += this.H[n][n13] * this.H[n13][n5];
                }
                d3 = this.H[n][n] - d6;
                if (this.e[n] < 0.0) {
                    d10 = d3;
                    d8 = d13;
                    d9 = d14;
                    continue;
                }
                n2 = n;
                if (this.e[n] == 0.0) {
                    this.cdiv(-d13, -d14, d3, d7);
                    this.H[n][n5 - 1] = this.cdivr;
                    this.H[n][n5] = this.cdivi;
                } else {
                    double d15;
                    d2 = this.H[n][n + 1];
                    d = this.H[n + 1][n];
                    double d16 = (this.d[n] - d6) * (this.d[n] - d6) + this.e[n] * this.e[n] - d7 * d7;
                    if (d16 == 0.0 & (d15 = (this.d[n] - d6) * 2.0 * d7) == 0.0) {
                        d16 = d4 * d11 * (Math.abs(d3) + Math.abs(d7) + Math.abs(d2) + Math.abs(d) + Math.abs(d10));
                    }
                    this.cdiv(d2 * d8 - d10 * d13 + d7 * d14, d2 * d9 - d10 * d14 - d7 * d13, d16, d15);
                    this.H[n][n5 - 1] = this.cdivr;
                    this.H[n][n5] = this.cdivi;
                    if (Math.abs(d2) > Math.abs(d10) + Math.abs(d7)) {
                        this.H[n + 1][n5 - 1] = (-d13 - d3 * this.H[n][n5 - 1] + d7 * this.H[n][n5]) / d2;
                        this.H[n + 1][n5] = (-d14 - d3 * this.H[n][n5] - d7 * this.H[n][n5 - 1]) / d2;
                    } else {
                        this.cdiv(-d8 - d * this.H[n][n5 - 1], -d9 - d * this.H[n][n5], d10, d7);
                        this.H[n + 1][n5 - 1] = this.cdivr;
                        this.H[n + 1][n5] = this.cdivi;
                    }
                }
                d12 = Math.max(Math.abs(this.H[n][n5 - 1]), Math.abs(this.H[n][n5]));
                if (!(d4 * d12 * d12 > 1.0)) continue;
                for (n13 = n; n13 <= n5; ++n13) {
                    this.H[n13][n5 - 1] = this.H[n13][n5 - 1] / d12;
                    this.H[n13][n5] = this.H[n13][n5] / d12;
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (!(n2 < n6 | n2 > n7)) continue;
            for (n = n2; n < n4; ++n) {
                this.V[n2][n] = this.H[n2][n];
            }
        }
        for (n2 = n4 - 1; n2 >= n6; --n2) {
            for (n = n6; n <= n7; ++n) {
                d10 = 0.0;
                for (int i = n6; i <= Math.min(n2, n7); ++i) {
                    d10 += this.V[n][i] * this.H[i][n2];
                }
                this.V[n][n2] = d10;
            }
        }
    }

    public EigenvalueDecomposition(Matrix matrix) {
        int n;
        double[][] dArray = matrix.getArray();
        this.n = matrix.getColumnDimension();
        this.V = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = true;
        int n2 = 0;
        while (n2 < this.n & this.issymmetric) {
            n = 0;
            while (n < this.n & this.issymmetric) {
                this.issymmetric = dArray[n][n2] == dArray[n2][n];
                ++n;
            }
            ++n2;
        }
        if (this.issymmetric) {
            for (n2 = 0; n2 < this.n; ++n2) {
                for (n = 0; n < this.n; ++n) {
                    this.V[n2][n] = dArray[n2][n];
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new double[this.n][this.n];
            this.ort = new double[this.n];
            for (n2 = 0; n2 < this.n; ++n2) {
                for (n = 0; n < this.n; ++n) {
                    this.H[n][n2] = dArray[n][n2];
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = 0.0;
            }
            dArray[i][i] = this.d[i];
            if (this.e[i] > 0.0) {
                dArray[i][i + 1] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            dArray[i][i - 1] = this.e[i];
        }
        return matrix;
    }
}

