/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.util;

import ch.ethz.globis.phtree.util.MinMaxHeapI;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class MinMaxHeapPool<T>
implements MinMaxHeapI.MinMaxHeapPoolI<T> {
    private static final int DEFAULT_SIZE = 16;
    private final Less<T> less;
    Supplier<T> supplyFn;
    private T[] data;
    private int size = 0;

    private MinMaxHeapPool(int capacity, Less<T> lessFn, Supplier<T> supplyFn) {
        this.data = new Object[capacity];
        this.less = lessFn;
        this.supplyFn = supplyFn;
    }

    public static <T extends Comparable<T>> MinMaxHeapPool<T> create(Supplier<T> supplyFn) {
        return new MinMaxHeapPool(16, new LessWrapper(Comparable::compareTo), supplyFn);
    }

    public static <T> MinMaxHeapPool<T> createWithComparator(Comparator<T> compareFn, Supplier<T> supplyFn) {
        return new MinMaxHeapPool<T>(16, new LessWrapper<T>(compareFn), supplyFn);
    }

    public static <T> MinMaxHeapPool<T> create(Less<T> lessFn, Supplier<T> supplyFn) {
        return new MinMaxHeapPool<T>(16, lessFn, supplyFn);
    }

    private static boolean isMinLevel(int index) {
        return (Integer.numberOfLeadingZeros(index) & 1) != 0;
    }

    private boolean hasChildren(int i) {
        return i * 2 <= this.size;
    }

    private boolean isGrandchildOf(int m3, int i) {
        return m3 >> 2 == i;
    }

    private void swap(int i1, int i2) {
        T v = this.data[i1];
        this.data[i1] = this.data[i2];
        this.data[i2] = v;
    }

    private int parent(int i) {
        return i >> 1;
    }

    private boolean hasGrandparent(int i) {
        return i >> 2 > 0;
    }

    private int grandparent(int i) {
        return i >> 2;
    }

    private int indexOfSmallestChildOrGrandchild(int index) {
        int min34;
        int min12;
        int end = this.end();
        int start = index * 4;
        int firstChild = index * 2;
        if (start >= end) {
            if (firstChild + 1 < end) {
                return this.less.less(this.data[firstChild], this.data[firstChild + 1]) ? firstChild : firstChild + 1;
            }
            return firstChild;
        }
        if (start + 1 < end) {
            min12 = start + (this.less.less(this.data[start], this.data[start + 1]) ? 0 : 1);
            min34 = (start += 2) + 1 < end ? (this.less.less(this.data[start], this.data[start + 1]) ? start : start + 1) : (start < end ? start : index * 2 + 1);
        } else {
            min12 = start;
            min34 = (start += 2) < end ? start : index * 2 + 1;
        }
        return this.less.less(this.data[min12], this.data[min34]) ? min12 : min34;
    }

    private int indexOfLargestChildOrGrandchild(int index) {
        int max34;
        int max12;
        int end = this.end();
        int start = index * 4;
        int firstChild = index * 2;
        if (start >= end) {
            if (firstChild + 1 < end) {
                return this.less.less(this.data[firstChild], this.data[firstChild + 1]) ? firstChild + 1 : firstChild;
            }
            return firstChild;
        }
        if (start + 1 < end) {
            max12 = start + (this.less.less(this.data[start], this.data[start + 1]) ? 1 : 0);
            max34 = (start += 2) + 1 < end ? (this.less.less(this.data[start], this.data[start + 1]) ? start + 1 : start) : (start < end ? start : index * 2 + 1);
        } else {
            max12 = start;
            max34 = (start += 2) < end ? start : index * 2 + 1;
        }
        return this.less.less(this.data[max12], this.data[max34]) ? max34 : max12;
    }

    private void pushDown(int m3) {
        while (this.hasChildren(m3)) {
            int i = m3;
            if (MinMaxHeapPool.isMinLevel(i)) {
                m3 = this.indexOfSmallestChildOrGrandchild(i);
                if (this.less.less(this.data[m3], this.data[i])) {
                    this.swap(m3, i);
                    if (this.isGrandchildOf(m3, i)) {
                        if (this.less.less(this.data[m3], this.data[this.parent(m3)])) continue;
                        this.swap(m3, this.parent(m3));
                        continue;
                    }
                    return;
                }
                return;
            }
            m3 = this.indexOfLargestChildOrGrandchild(i);
            if (!this.less.less(this.data[m3], this.data[i])) {
                this.swap(m3, i);
                if (this.isGrandchildOf(m3, i)) {
                    if (!this.less.less(this.data[m3], this.data[this.parent(m3)])) continue;
                    this.swap(m3, this.parent(m3));
                    continue;
                }
                return;
            }
            return;
        }
    }

    private void pushUp(int index) {
        if (MinMaxHeapPool.isMinLevel(index)) {
            if (!this.less.less(this.data[index], this.data[this.parent(index)])) {
                this.swap(index, this.parent(index));
                this.pushUpMax(this.parent(index));
            } else {
                this.pushUpMin(index);
            }
        } else if (this.less.less(this.data[index], this.data[this.parent(index)])) {
            this.swap(index, this.parent(index));
            this.pushUpMin(this.parent(index));
        } else {
            this.pushUpMax(index);
        }
    }

    private void pushUpMin(int index) {
        while (this.hasGrandparent(index) && this.less.less(this.data[index], this.data[this.grandparent(index)])) {
            this.swap(index, this.grandparent(index));
            index = this.grandparent(index);
        }
    }

    private void pushUpMax(int index) {
        while (this.hasGrandparent(index) && !this.less.less(this.data[index], this.data[this.grandparent(index)])) {
            this.swap(index, this.grandparent(index));
            index = this.grandparent(index);
        }
    }

    private int end() {
        return this.size + 1;
    }

    @Override
    public void push(T value) {
        if (this.size == 0) {
            this.data[1] = value;
            ++this.size;
            return;
        }
        if (this.size + 2 >= this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        ++this.size;
        this.data[this.size] = value;
        this.pushUp(this.size);
    }

    @Override
    public T getObject() {
        T obj = this.data[this.end()];
        return obj != null ? obj : this.supplyFn.get();
    }

    @Override
    public void popMin() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        if (this.size == 0) {
            return;
        }
        this.swap(1, this.end());
        this.pushDown(1);
    }

    @Override
    public void popMax() {
        int max;
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        if (this.size <= 2) {
            --this.size;
            return;
        }
        int n = max = this.less.less(this.data[2], this.data[3]) ? 3 : 2;
        if (this.size == 3) {
            --this.size;
            if (max == 2) {
                this.swap(2, 3);
            }
            return;
        }
        int end = this.end();
        this.swap(max, end - 1);
        --this.size;
        this.pushDown(max);
    }

    @Override
    public T peekMin() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        return this.data[1];
    }

    @Override
    public T peekMax() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        if (this.size == 1) {
            return this.data[1];
        }
        if (this.size == 2) {
            return this.data[2];
        }
        return this.less.less(this.data[2], this.data[3]) ? this.data[3] : this.data[2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public String print() {
        StringBuilderLn s2 = new StringBuilderLn();
        int x = 2;
        for (int i = 1; i <= this.size; ++i) {
            if (i % x == 0) {
                s2.appendLn();
                x *= 2;
            }
            s2.append(this.data[i] + "   ");
        }
        s2.appendLn();
        return s2.toString();
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    static class LessWrapper<C>
    implements Less<C> {
        private final Comparator<C> comp;

        LessWrapper(Comparator<C> comp) {
            this.comp = comp;
        }

        @Override
        public boolean less(C o1, C o2) {
            return this.comp.compare(o1, o2) < 0;
        }
    }

    @FunctionalInterface
    public static interface Less<T> {
        public boolean less(T var1, T var2);
    }
}

