/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import jsinterop.annotations.JsConstructor;
import org.apache.sedona.shaded.s2.R2Rect;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2ContainsPointQuery;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2IndexCellData;
import org.apache.sedona.shaded.s2.S2PaddedCell;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Projections;
import org.apache.sedona.shaded.s2.S2RobustCellClipper;
import org.apache.sedona.shaded.s2.S2ShapeIndex;

public class S2ReclippedShape {
    private final List<S2RobustCellClipper.Crossing> crossings = new ArrayList<S2RobustCellClipper.Crossing>();
    private final List<Edge> edges = new ArrayList<Edge>();
    private S2CellId cellId;
    private int dimension = -1;
    private int shapeId = -1;
    private boolean containsCenter;

    public void reset() {
        this.shapeId = -1;
    }

    @CanIgnoreReturnValue
    public boolean init(S2RobustCellClipper clipper, S2ShapeIndex.S2ClippedShape clipped, S2IndexCellData indexCellData, boolean saveCrossings) {
        assert (indexCellData.id().contains(clipper.cell().id()));
        if (this.shapeId == clipped.shapeId()) {
            return false;
        }
        this.shapeId = clipped.shapeId();
        this.dimension = indexCellData.shape(this.shapeId).dimension();
        S2Cell clipCell = clipper.cell();
        this.cellId = clipCell.id();
        this.edges.clear();
        this.crossings.clear();
        this.containsCenter = clipped.containsCenter();
        if (this.dimension == 2 && !clipCell.id().equals(indexCellData.id())) {
            this.containsCenter = indexCellData.shapeContains(clipped, clipCell.getCenter(), S2ContainsPointQuery.S2VertexModel.SEMI_OPEN);
        }
        clipper.reset();
        for (S2IndexCellData.EdgeAndIdChain edge : indexCellData.shapeEdges(this.shapeId)) {
            S2RobustCellClipper.RobustClipResult result = clipper.clipEdge(edge);
            if (!result.hit()) continue;
            Edge newEdge = new Edge(edge);
            this.edges.add(newEdge);
            newEdge.v0Contained = result.v0Inside();
            newEdge.v1Contained = result.v1Inside();
        }
        if (saveCrossings && clipper.options().enableCrossings()) {
            for (S2RobustCellClipper.Crossing crossing : clipper.getCrossings()) {
                this.crossings.add(crossing);
            }
        }
        return true;
    }

    @CanIgnoreReturnValue
    public boolean init(S2RobustCellClipper clipper, S2ShapeIndex.S2ClippedShape clipped, S2IndexCellData data) {
        return this.init(clipper, clipped, data, true);
    }

    public S2CellId cellId() {
        return this.cellId;
    }

    public int shapeId() {
        return this.shapeId;
    }

    public int dimension() {
        if (this.shapeId() >= 0) {
            return this.dimension;
        }
        return -1;
    }

    public boolean containsCenter() {
        return this.containsCenter;
    }

    public List<Edge> edges() {
        return this.edges;
    }

    public List<S2RobustCellClipper.Crossing> crossings() {
        return this.crossings;
    }

    private boolean pointInCell(S2Point point) {
        R2Rect bounds = new S2PaddedCell(this.cellId(), S2ShapeIndex.CELL_PADDING).bound();
        R2Vector uv = new R2Vector();
        S2Cell cell = new S2Cell(this.cellId());
        S2Projections.validFaceXyzToUv(cell.face(), point, uv);
        return bounds.contains(uv);
    }

    public boolean contains(S2Point center, S2Point point, S2ContainsPointQuery.S2VertexModel model) {
        assert (this.pointInCell(point));
        assert (center.equalsPoint(this.cellId().toPoint()));
        assert (this.shapeId() >= 0);
        if (this.dimension() < 2) {
            if (model != S2ContainsPointQuery.S2VertexModel.CLOSED) {
                return false;
            }
            for (Edge edge : this.edges()) {
                if (!edge.v0.equalsPoint(point) && !edge.v1.equalsPoint(point)) continue;
                return true;
            }
            return false;
        }
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(center, point);
        boolean inside = this.containsCenter();
        for (Edge edge : this.edges()) {
            int sign = crosser.robustCrossing(edge.v0, edge.v1);
            if (sign < 0) continue;
            if (sign == 0) {
                if (model != S2ContainsPointQuery.S2VertexModel.SEMI_OPEN && (edge.v0.equalsPoint(point) || edge.v1.equalsPoint(point))) {
                    return model == S2ContainsPointQuery.S2VertexModel.CLOSED;
                }
                sign = S2EdgeUtil.vertexCrossing(crosser.a(), crosser.b(), edge.v0, edge.v1) ? 1 : 0;
            }
            inside ^= sign != 0;
        }
        return inside;
    }

    public boolean contains(S2Point center, S2Point point) {
        return this.contains(center, point, S2ContainsPointQuery.S2VertexModel.OPEN);
    }

    public static class Edge {
        public final S2Point v0;
        public final S2Point v1;
        public final int chainId;
        public final int offset;
        public boolean v0Contained;
        public boolean v1Contained;

        public Edge(S2IndexCellData.EdgeAndIdChain edge) {
            this(edge.start(), edge.end(), edge.chainId(), edge.offset());
        }

        public Edge(S2Point v0, S2Point v1) {
            this(v0, v1, -1, -1);
        }

        @JsConstructor
        public Edge(S2Point v0, S2Point v1, int chainId, int offset) {
            this.v0 = v0;
            this.v1 = v1;
            this.chainId = chainId;
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)o;
            return this.v0.equalsPoint(other.v0) && this.v1.equalsPoint(other.v1);
        }

        public int hashCode() {
            return this.v0.hashCode() * 13 + this.v1.hashCode();
        }

        public Edge reversed() {
            return new Edge(this.v1, this.v0);
        }

        public boolean outgoing(S2Point point) {
            return this.v0.equalsPoint(point);
        }

        public boolean incoming(S2Point point) {
            return this.v1.equalsPoint(point);
        }

        public boolean incidentOn(S2Point point) {
            return this.v0.equalsPoint(point) || this.v1.equalsPoint(point);
        }

        public boolean isDegenerate() {
            return this.v0.equalsPoint(this.v1);
        }

        public boolean hasSameEndpoints(Edge other) {
            return this.v0.equalsPoint(other.v0) && this.v1.equalsPoint(other.v1);
        }

        public boolean isSiblingOf(Edge other) {
            return this.v0.equalsPoint(other.v1) && this.v1.equalsPoint(other.v0);
        }
    }
}

