/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.advice;

import java.util.Arrays;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.core.advice.AbstractInstanceMethodAdvice;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.CounterMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class RouteResultCountAdvice
extends AbstractInstanceMethodAdvice {
    private final MetricConfiguration routedResultConfig = new MetricConfiguration("routed_result_total", MetricCollectorType.COUNTER, "Total count of routed result", Arrays.asList("object", "name"));

    public void afterMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, Object result, String pluginType) {
        if (null == result) {
            return;
        }
        for (RouteUnit each : ((RouteContext)result).getRouteUnits()) {
            ((CounterMetricsCollector)MetricsCollectorRegistry.get(this.routedResultConfig, pluginType)).inc("data_source", each.getDataSourceMapper().getActualName());
            each.getTableMappers().forEach(table -> ((CounterMetricsCollector)MetricsCollectorRegistry.get(this.routedResultConfig, pluginType)).inc("table", table.getActualName()));
        }
    }
}

