/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.DoubleExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoirFactory;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.LongExemplarReservoir;

@ThreadSafe
public abstract class AggregatorHandle<T extends PointData> {
    private static final String UNSUPPORTED_LONG_MESSAGE = "This aggregator does not support long values.";
    private static final String UNSUPPORTED_DOUBLE_MESSAGE = "This aggregator does not support double values.";
    @Nullable
    private final DoubleExemplarReservoir doubleReservoirFactory;
    @Nullable
    private final LongExemplarReservoir longReservoirFactory;
    private final boolean isDoubleType;
    private volatile boolean valuesRecorded = false;

    protected AggregatorHandle(ExemplarReservoirFactory reservoirFactory, boolean isDoubleType) {
        this.isDoubleType = isDoubleType;
        if (isDoubleType) {
            this.doubleReservoirFactory = reservoirFactory.createDoubleExemplarReservoir();
            this.longReservoirFactory = null;
        } else {
            this.doubleReservoirFactory = null;
            this.longReservoirFactory = reservoirFactory.createLongExemplarReservoir();
        }
    }

    public final T aggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, boolean reset) {
        if (reset) {
            this.valuesRecorded = false;
        }
        if (this.isDoubleType) {
            return this.doAggregateThenMaybeResetDoubles(startEpochNanos, epochNanos, attributes, AggregatorHandle.throwUnsupportedIfNull(this.doubleReservoirFactory, UNSUPPORTED_DOUBLE_MESSAGE).collectAndResetDoubles(attributes), reset);
        }
        return this.doAggregateThenMaybeResetLongs(startEpochNanos, epochNanos, attributes, AggregatorHandle.throwUnsupportedIfNull(this.longReservoirFactory, UNSUPPORTED_LONG_MESSAGE).collectAndResetLongs(attributes), reset);
    }

    protected T doAggregateThenMaybeResetDoubles(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
        throw new UnsupportedOperationException(UNSUPPORTED_DOUBLE_MESSAGE);
    }

    protected T doAggregateThenMaybeResetLongs(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
        throw new UnsupportedOperationException(UNSUPPORTED_LONG_MESSAGE);
    }

    public void recordLong(long value, Attributes attributes, Context context) {
        AggregatorHandle.throwUnsupportedIfNull(this.longReservoirFactory, UNSUPPORTED_LONG_MESSAGE).offerLongMeasurement(value, attributes, context);
        this.doRecordLong(value);
        this.valuesRecorded = true;
    }

    protected void doRecordLong(long value) {
        throw new UnsupportedOperationException(UNSUPPORTED_LONG_MESSAGE);
    }

    public final void recordDouble(double value, Attributes attributes, Context context) {
        AggregatorHandle.throwUnsupportedIfNull(this.doubleReservoirFactory, UNSUPPORTED_DOUBLE_MESSAGE).offerDoubleMeasurement(value, attributes, context);
        this.doRecordDouble(value);
        this.valuesRecorded = true;
    }

    protected void doRecordDouble(double value) {
        throw new UnsupportedOperationException(UNSUPPORTED_DOUBLE_MESSAGE);
    }

    public boolean hasRecordedValues() {
        return this.valuesRecorded;
    }

    private static <S> S throwUnsupportedIfNull(@Nullable S value, String message) {
        if (value == null) {
            throw new UnsupportedOperationException(message);
        }
        return value;
    }
}

