/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import org.apache.shardingsphere.shade.kotlin.ExceptionsKt;
import org.apache.shardingsphere.shade.kotlin.Metadata;
import org.apache.shardingsphere.shade.kotlin.jvm.internal.Intrinsics;
import org.apache.shardingsphere.shade.kotlin.text.StringsKt;
import org.apache.shardingsphere.shade.okhttp3.Headers;
import org.apache.shardingsphere.shade.okhttp3.Interceptor;
import org.apache.shardingsphere.shade.okhttp3.Request;
import org.apache.shardingsphere.shade.okhttp3.RequestBody;
import org.apache.shardingsphere.shade.okhttp3.Response;
import org.apache.shardingsphere.shade.okhttp3.ResponseBody;
import org.apache.shardingsphere.shade.okhttp3.TrailersSource;
import org.apache.shardingsphere.shade.okhttp3.internal.UnreadableResponseBody;
import org.apache.shardingsphere.shade.okhttp3.internal._UtilJvmKt;
import org.apache.shardingsphere.shade.okhttp3.internal.connection.Exchange;
import org.apache.shardingsphere.shade.okhttp3.internal.http.HttpMethod;
import org.apache.shardingsphere.shade.okhttp3.internal.http.RealInterceptorChain;
import org.apache.shardingsphere.shade.okhttp3.internal.http2.ConnectionShutdownException;
import org.apache.shardingsphere.shade.okio.BufferedSink;
import org.apache.shardingsphere.shade.okio.BufferedSource;
import org.apache.shardingsphere.shade.okio.Okio;
import org.apache.shardingsphere.shade.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/apache/shardingsphere/shade/okhttp3/internal/http/CallServerInterceptor;", "Lorg/apache/shardingsphere/shade/okhttp3/Interceptor;", "<init>", "()V", "intercept", "Lorg/apache/shardingsphere/shade/okhttp3/Response;", "chain", "Lorg/apache/shardingsphere/shade/okhttp3/Interceptor$Chain;", "shouldIgnoreAndWaitForRealResponse", "", "code", "", "okhttp"})
public final class CallServerInterceptor
implements Interceptor {
    @NotNull
    public static final CallServerInterceptor INSTANCE = new CallServerInterceptor();

    private CallServerInterceptor() {
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter(chain, "chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Exchange exchange = realChain.getExchange$okhttp();
        Intrinsics.checkNotNull(exchange);
        Exchange exchange2 = exchange;
        Request request = realChain.getRequest$okhttp();
        RequestBody requestBody = request.body();
        long sentRequestMillis = System.currentTimeMillis();
        boolean invokeStartEvent = true;
        Response.Builder responseBuilder = null;
        IOException sendRequestException = null;
        boolean hasRequestBody = HttpMethod.permitsRequestBody(request.method()) && requestBody != null;
        boolean isUpgradeRequest = StringsKt.equals("upgrade", request.header("Connection"), true);
        try {
            exchange2.writeRequestHeaders(request);
            if (hasRequestBody) {
                if (StringsKt.equals("100-continue", request.header("Expect"), true)) {
                    exchange2.flushRequest();
                    responseBuilder = exchange2.readResponseHeaders(true);
                    exchange2.responseHeadersStart();
                    invokeStartEvent = false;
                }
                if (responseBuilder == null) {
                    BufferedSink bufferedRequestBody;
                    if (requestBody.isDuplex()) {
                        exchange2.flushRequest();
                        bufferedRequestBody = Okio.buffer(exchange2.createRequestBody(request, true));
                        requestBody.writeTo(bufferedRequestBody);
                    } else {
                        bufferedRequestBody = Okio.buffer(exchange2.createRequestBody(request, false));
                        requestBody.writeTo(bufferedRequestBody);
                        bufferedRequestBody.close();
                    }
                } else {
                    exchange2.noRequestBody();
                    if (!exchange2.getConnection$okhttp().isMultiplexed$okhttp()) {
                        exchange2.noNewExchangesOnConnection();
                    }
                }
            } else {
                exchange2.noRequestBody();
            }
            if (requestBody == null || !requestBody.isDuplex()) {
                exchange2.finishRequest();
            }
        }
        catch (IOException e) {
            if (e instanceof ConnectionShutdownException) {
                throw e;
            }
            if (!exchange2.getHasFailure$okhttp()) {
                throw e;
            }
            sendRequestException = e;
        }
        try {
            Response response;
            boolean isUpgradeCode;
            if (responseBuilder == null) {
                Response.Builder builder = exchange2.readResponseHeaders(false);
                Intrinsics.checkNotNull(builder);
                responseBuilder = builder;
                if (invokeStartEvent) {
                    exchange2.responseHeadersStart();
                    invokeStartEvent = false;
                }
            }
            Response response2 = responseBuilder.request(request).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
            int code = response2.code();
            while (this.shouldIgnoreAndWaitForRealResponse(code)) {
                Intrinsics.checkNotNull(exchange2.readResponseHeaders(false));
                if (invokeStartEvent) {
                    exchange2.responseHeadersStart();
                }
                response2 = responseBuilder.request(request).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
                code = response2.code();
            }
            exchange2.responseHeadersEnd(response2);
            boolean bl = isUpgradeCode = code == 101;
            if (isUpgradeCode && exchange2.getConnection$okhttp().isMultiplexed$okhttp()) {
                throw new ProtocolException("Unexpected 101 code on HTTP/2 connection");
            }
            boolean isUpgradeResponse = isUpgradeCode && StringsKt.equals("upgrade", Response.header$default(response2, "Connection", null, 2, null), true);
            if (isUpgradeRequest && isUpgradeResponse) {
                response = response2.newBuilder().body(new UnreadableResponseBody(response2.body().contentType(), response2.body().contentLength())).socket(exchange2.upgradeToSocket()).build();
            } else {
                ResponseBody responseBody = exchange2.openResponseBody(response2);
                response = response2 = response2.newBuilder().body(responseBody).trailers(new TrailersSource(exchange2, responseBody){
                    final /* synthetic */ Exchange $exchange;
                    final /* synthetic */ ResponseBody $responseBody;
                    {
                        this.$exchange = $exchange;
                        this.$responseBody = $responseBody;
                    }

                    public Headers peek() {
                        return this.$exchange.peekTrailers();
                    }

                    public Headers get() {
                        BufferedSource source2 = this.$responseBody.source();
                        if (source2.isOpen()) {
                            _UtilJvmKt.skipAll(source2);
                        }
                        Headers headers = this.peek();
                        if (headers == null) {
                            throw new IllegalStateException("null trailers after exhausting response body?!".toString());
                        }
                        return headers;
                    }
                }).build();
            }
            if (StringsKt.equals("close", response2.request().header("Connection"), true) || StringsKt.equals("close", Response.header$default(response2, "Connection", null, 2, null), true)) {
                exchange2.noNewExchangesOnConnection();
            }
            if ((code == 204 || code == 205) && response2.body().contentLength() > 0L) {
                throw new ProtocolException("HTTP " + code + " had non-zero Content-Length: " + response2.body().contentLength());
            }
            return response2;
        }
        catch (IOException e) {
            if (sendRequestException != null) {
                ExceptionsKt.addSuppressed(sendRequestException, e);
                throw sendRequestException;
            }
            throw e;
        }
    }

    private final boolean shouldIgnoreAndWaitForRealResponse(int code) {
        return code == 100 ? true : (102 <= code ? code < 200 : false);
    }
}

