/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.window;

import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowSegment;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.orderby.OrderByConverter;

public final class WindowConverter {
    public static Optional<SqlNodeList> convert(WindowSegment segment) {
        LinkedList<SqlWindow> sqlWindows = new LinkedList<SqlWindow>();
        for (WindowItemSegment each : segment.getItemSegments()) {
            SqlWindow sqlWindow = WindowConverter.convertWindowItem(each);
            sqlWindows.add(sqlWindow);
        }
        SqlNodeList result = new SqlNodeList(sqlWindows, SqlParserPos.ZERO);
        return Optional.of(result);
    }

    public static SqlWindow convertWindowItem(WindowItemSegment windowItemSegment) {
        SqlIdentifier sqlIdentifier = null == windowItemSegment.getWindowName() ? null : new SqlIdentifier(windowItemSegment.getWindowName().getValue(), SqlParserPos.ZERO);
        LinkedList partitionNodes = new LinkedList();
        windowItemSegment.getPartitionListSegments().forEach(expressionSegment -> ExpressionConverter.convert(expressionSegment).ifPresent(partitionNodes::add));
        SqlNodeList partitionList = new SqlNodeList(partitionNodes, SqlParserPos.ZERO);
        SqlNodeList orderList = new SqlNodeList(SqlParserPos.ZERO);
        OrderByConverter.convert(windowItemSegment.getOrderBySegment()).ifPresent(arg_0 -> ((SqlNodeList)orderList).addAll(arg_0));
        return new SqlWindow(SqlParserPos.ZERO, sqlIdentifier, null, partitionList, orderList, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), null, null, null);
    }

    @Generated
    private WindowConverter() {
    }
}

