/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.federation.type;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.mode.metadata.refresher.federation.FederationMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;

public final class AlterViewFederationMetaDataRefresher
implements FederationMetaDataRefresher<AlterViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, DatabaseType databaseType, ShardingSphereDatabase database, String schemaName, AlterViewStatement sqlStatement) {
        String viewName = TableRefreshUtils.getTableName(sqlStatement.getView().getTableName().getIdentifier(), databaseType);
        Optional renameView = sqlStatement.getRenameView();
        LinkedList<ShardingSphereView> alteredViews = new LinkedList<ShardingSphereView>();
        LinkedList<String> droppedViews = new LinkedList<String>();
        if (renameView.isPresent()) {
            String renameViewName = ((SimpleTableSegment)renameView.get()).getTableName().getIdentifier().getValue();
            String originalView = database.getSchema(schemaName).getView(viewName).getViewDefinition();
            alteredViews.add(new ShardingSphereView(renameViewName, originalView));
            droppedViews.add(viewName);
        }
        sqlStatement.getViewDefinition().ifPresent(optional -> alteredViews.add(new ShardingSphereView(viewName, optional)));
        metaDataManagerPersistService.alterViews(database, schemaName, alteredViews);
        metaDataManagerPersistService.dropViews(database, schemaName, droppedViews);
    }

    @Override
    public Class<AlterViewStatement> getType() {
        return AlterViewStatement.class;
    }
}

