/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.decorator.RuleConfigurationDecorator;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class ShardingSphereDatabase {
    private final String name;
    private final DatabaseType protocolType;
    private final ResourceMetaData resourceMetaData;
    private final RuleMetaData ruleMetaData;
    private final Map<ShardingSphereIdentifier, ShardingSphereSchema> schemas;

    public ShardingSphereDatabase(String name, DatabaseType protocolType, ResourceMetaData resourceMetaData, RuleMetaData ruleMetaData, Collection<ShardingSphereSchema> schemas) {
        this.name = name;
        this.protocolType = protocolType;
        this.resourceMetaData = resourceMetaData;
        this.ruleMetaData = ruleMetaData;
        this.schemas = new ConcurrentHashMap<ShardingSphereIdentifier, ShardingSphereSchema>(schemas.stream().collect(Collectors.toMap(each -> new ShardingSphereIdentifier(each.getName()), each -> each)));
    }

    public Collection<ShardingSphereSchema> getAllSchemas() {
        return this.schemas.values();
    }

    public boolean containsSchema(String schemaName) {
        return this.schemas.containsKey(new ShardingSphereIdentifier(schemaName));
    }

    public ShardingSphereSchema getSchema(String schemaName) {
        return this.schemas.get(new ShardingSphereIdentifier(schemaName));
    }

    public void addSchema(ShardingSphereSchema schema) {
        this.schemas.put(new ShardingSphereIdentifier(schema.getName()), schema);
    }

    public void dropSchema(String schemaName) {
        this.schemas.remove(new ShardingSphereIdentifier(schemaName));
    }

    public boolean isComplete() {
        return !this.ruleMetaData.getRules().isEmpty() && !this.resourceMetaData.getStorageUnits().isEmpty();
    }

    public boolean containsDataSource() {
        return !this.resourceMetaData.getStorageUnits().isEmpty();
    }

    public synchronized void reloadRules() {
        Collection toBeReloadedRules = this.ruleMetaData.getRules().stream().filter(each -> each.getAttributes().findAttribute(MutableDataNodeRuleAttribute.class).isPresent()).collect(Collectors.toList());
        RuleConfiguration ruleConfig = toBeReloadedRules.stream().map(ShardingSphereRule::getConfiguration).findFirst().orElse(null);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(this.ruleMetaData.getRules());
        toBeReloadedRules.stream().findFirst().ifPresent(optional -> {
            rules.removeAll(toBeReloadedRules);
            Map dataSources = this.resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
            rules.add(optional.getAttributes().getAttribute(MutableDataNodeRuleAttribute.class).reloadRule(ruleConfig, this.name, dataSources, rules));
        });
        this.ruleMetaData.getRules().clear();
        this.ruleMetaData.getRules().addAll(rules);
    }

    public void checkStorageUnitsExisted(Collection<String> storageUnitNames) {
        Collection<String> notExistedDataSources = this.resourceMetaData.getNotExistedDataSources(storageUnitNames);
        Collection logicDataSources = this.ruleMetaData.getAttributes(DataSourceMapperRuleAttribute.class).stream().flatMap(each -> each.getDataSourceMapper().keySet().stream()).collect(Collectors.toSet());
        notExistedDataSources.removeIf(logicDataSources::contains);
        ShardingSpherePreconditions.checkMustEmpty(notExistedDataSources, () -> new MissingRequiredStorageUnitsException(this.name, notExistedDataSources));
    }

    public RuleConfiguration decorateRuleConfiguration(RuleConfiguration ruleConfig) {
        Optional decorator = TypedSPILoader.findService(RuleConfigurationDecorator.class, ruleConfig.getClass());
        if (!decorator.isPresent()) {
            return ruleConfig;
        }
        Map dataSources = this.resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return ((RuleConfigurationDecorator)decorator.get()).decorate(this.name, dataSources, this.ruleMetaData.getRules(), ruleConfig);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DatabaseType getProtocolType() {
        return this.protocolType;
    }

    @Generated
    public ResourceMetaData getResourceMetaData() {
        return this.resourceMetaData;
    }

    @Generated
    public RuleMetaData getRuleMetaData() {
        return this.ruleMetaData;
    }
}

