/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabaseFactory;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;

public final class ShardingSphereDatabasesFactory {
    public static Collection<ShardingSphereDatabase> create(Map<String, DatabaseConfiguration> databaseConfigMap, Map<String, Collection<ShardingSphereSchema>> schemas, ConfigurationProperties props, ComputeNodeInstanceContext instanceContext, DatabaseType protocolType) {
        return databaseConfigMap.entrySet().stream().map(entry -> ShardingSphereDatabasesFactory.create((String)entry.getKey(), (DatabaseConfiguration)entry.getValue(), protocolType, (Collection)schemas.get(entry.getKey()), props, instanceContext)).collect(Collectors.toList());
    }

    private static ShardingSphereDatabase create(String databaseName, DatabaseConfiguration databaseConfig, DatabaseType protocolType, Collection<ShardingSphereSchema> schemas, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) {
        return databaseConfig.getStorageUnits().isEmpty() ? ShardingSphereDatabaseFactory.create(databaseName, protocolType, props) : ShardingSphereDatabaseFactory.create(databaseName, protocolType, databaseConfig, computeNodeInstanceContext, schemas);
    }

    public static Collection<ShardingSphereDatabase> create(Map<String, DatabaseConfiguration> databaseConfigMap, ConfigurationProperties props, ComputeNodeInstanceContext instanceContext, DatabaseType protocolType) throws SQLException {
        SystemDatabase systemDatabase = new SystemDatabase(protocolType);
        LinkedList<ShardingSphereDatabase> result = new LinkedList<ShardingSphereDatabase>();
        result.addAll(ShardingSphereDatabasesFactory.createGenericDatabases(databaseConfigMap, protocolType, systemDatabase, props, instanceContext));
        result.addAll(ShardingSphereDatabasesFactory.createSystemDatabases(databaseConfigMap, protocolType, systemDatabase, props));
        return result;
    }

    private static Collection<ShardingSphereDatabase> createGenericDatabases(Map<String, DatabaseConfiguration> databaseConfigMap, DatabaseType protocolType, SystemDatabase systemDatabase, ConfigurationProperties props, ComputeNodeInstanceContext instanceContext) throws SQLException {
        HashSet<ShardingSphereDatabase> result = new HashSet<ShardingSphereDatabase>(databaseConfigMap.size(), 1.0f);
        for (Map.Entry<String, DatabaseConfiguration> entry : databaseConfigMap.entrySet()) {
            String databaseName = entry.getKey();
            if (entry.getValue().getStorageUnits().isEmpty() && systemDatabase.getSystemSchemas().contains(databaseName)) continue;
            result.add(ShardingSphereDatabaseFactory.create(databaseName, protocolType, entry.getValue(), props, instanceContext));
        }
        return result;
    }

    private static Collection<ShardingSphereDatabase> createSystemDatabases(Map<String, DatabaseConfiguration> databaseConfigMap, DatabaseType protocolType, SystemDatabase systemDatabase, ConfigurationProperties props) {
        HashSet<ShardingSphereDatabase> result = new HashSet<ShardingSphereDatabase>(systemDatabase.getSystemDatabases().size(), 1.0f);
        for (String each : systemDatabase.getSystemDatabases()) {
            if (databaseConfigMap.containsKey(each) && !databaseConfigMap.get(each).getStorageUnits().isEmpty()) continue;
            result.add(ShardingSphereDatabaseFactory.create(each, protocolType, props));
        }
        return result;
    }

    @Generated
    private ShardingSphereDatabasesFactory() {
    }
}

