/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.retriever.dml.table.column.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.UpdateStatementContext;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.column.ShadowColumnDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.util.ShadowExtractor;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;

public final class ShadowUpdateStatementDataSourceMappingsRetriever
extends ShadowColumnDataSourceMappingsRetriever {
    private final UpdateStatementContext sqlStatementContext;
    private final List<Object> parameters;

    public ShadowUpdateStatementDataSourceMappingsRetriever(UpdateStatementContext sqlStatementContext, List<Object> parameters) {
        super(ShadowOperationType.UPDATE);
        this.sqlStatementContext = sqlStatementContext;
        this.parameters = parameters;
    }

    @Override
    protected Collection<ShadowColumnCondition> getShadowColumnConditions(String shadowColumnName) {
        LinkedList<ShadowColumnCondition> result = new LinkedList<ShadowColumnCondition>();
        for (ExpressionSegment each : this.getWhereSegment()) {
            if (1 != ColumnExtractor.extract((ExpressionSegment)each).size()) continue;
            String tableName = (String)this.sqlStatementContext.getTablesContext().getTableNames().iterator().next();
            ShadowExtractor.extractValues(each, this.parameters).map(values -> new ShadowColumnCondition(tableName, shadowColumnName, (Collection<Comparable<?>>)values)).ifPresent(result::add);
        }
        return result;
    }

    private Collection<ExpressionSegment> getWhereSegment() {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.sqlStatementContext.getWhereSegments()) {
            result.addAll(ExpressionExtractor.extractAllExpressions((ExpressionSegment)each.getExpr()));
        }
        return result;
    }
}

