/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.YamlShardingAutoTableRuleConfigurationSwapper;

public final class ShardingAutoTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, ShardingAutoTableRuleConfiguration> {
    public ShardingAutoTableRuleConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        return new YamlShardingAutoTableRuleConfigurationSwapper().swapToObject((YamlShardingAutoTableRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShardingAutoTableRuleConfiguration.class));
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig, ShardingAutoTableRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getAutoTables().removeIf(each -> each.getLogicTable().equals(itemName));
        currentRuleConfig.getAutoTables().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getAutoTables().removeIf(each -> each.getLogicTable().equals(itemName));
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("sharding", "auto_tables");
    }
}

