/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.ExecuteQueryCallbackFactory;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteCallback;
import org.apache.shardingsphere.driver.executor.callback.replay.StatementReplayCallback;
import org.apache.shardingsphere.driver.executor.engine.pushdown.jdbc.DriverJDBCPushDownExecuteExecutor;
import org.apache.shardingsphere.driver.executor.engine.pushdown.raw.DriverRawPushDownExecuteExecutor;
import org.apache.shardingsphere.driver.executor.engine.transaction.DriverTransactionSQLStatementExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.raw.RawExecutionRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.metadata.refresher.federation.FederationMetaDataRefreshEngine;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;
import org.apache.shardingsphere.sqlfederation.context.SQLFederationContext;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;

public final class DriverExecuteExecutor {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final DriverJDBCPushDownExecuteExecutor jdbcPushDownExecutor;
    private final DriverRawPushDownExecuteExecutor rawPushDownExecutor;
    private final SQLFederationEngine sqlFederationEngine;
    private final DriverTransactionSQLStatementExecutor transactionExecutor;
    private ExecuteType executeType;

    public DriverExecuteExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, JDBCExecutor jdbcExecutor, RawExecutor rawExecutor, SQLFederationEngine sqlFederationEngine, DriverTransactionSQLStatementExecutor transactionExecutor) {
        this.connection = connection;
        this.metaData = metaData;
        this.jdbcPushDownExecutor = new DriverJDBCPushDownExecuteExecutor(connection, metaData, jdbcExecutor);
        this.rawPushDownExecutor = new DriverRawPushDownExecuteExecutor(connection, metaData, rawExecutor);
        this.sqlFederationEngine = sqlFederationEngine;
        this.transactionExecutor = transactionExecutor;
    }

    public boolean execute(ShardingSphereDatabase database, QueryContext queryContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementExecuteCallback executeCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        if (this.sqlFederationEngine.decide(queryContext, this.metaData.getGlobalRuleMetaData())) {
            this.executeType = ExecuteType.FEDERATION;
            ResultSet resultSet = this.sqlFederationEngine.executeQuery(prepareEngine, (JDBCExecutorCallback)new ExecuteQueryCallbackFactory(prepareEngine.getType()).newInstance(database, queryContext), new SQLFederationContext(false, queryContext, this.metaData, this.connection.getProcessId()));
            return null != resultSet;
        }
        FederationMetaDataRefreshEngine federationMetaDataRefreshEngine = new FederationMetaDataRefreshEngine(queryContext.getSqlStatementContext());
        if (this.sqlFederationEngine.isSQLFederationEnabled() && federationMetaDataRefreshEngine.isNeedRefresh()) {
            federationMetaDataRefreshEngine.refresh(this.connection.getContextManager().getPersistServiceFacade().getModeFacade().getMetaDataManagerService(), database);
            return true;
        }
        if (this.transactionExecutor.decide(queryContext)) {
            return this.transactionExecutor.execute((TCLStatement)queryContext.getSqlStatementContext().getSqlStatement());
        }
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(queryContext, this.metaData.getGlobalRuleMetaData(), this.metaData.getProps());
        return this.executePushDown(database, executionContext, prepareEngine, executeCallback, addCallback, replayCallback);
    }

    private boolean executePushDown(ShardingSphereDatabase database, ExecutionContext executionContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementExecuteCallback executeCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        if (database.getRuleMetaData().getAttributes(RawExecutionRuleAttribute.class).isEmpty()) {
            this.executeType = ExecuteType.JDBC_PUSH_DOWN;
            return this.jdbcPushDownExecutor.execute(database, executionContext, prepareEngine, executeCallback, addCallback, replayCallback);
        }
        this.executeType = ExecuteType.RAW_PUSH_DOWN;
        return this.rawPushDownExecutor.execute(database, executionContext);
    }

    public Optional<ResultSet> getResultSet(ShardingSphereDatabase database, QueryContext queryContext, Statement statement, List<? extends Statement> statements) throws SQLException {
        if (null == this.executeType) {
            return Optional.empty();
        }
        switch (this.executeType) {
            case FEDERATION: {
                return Optional.ofNullable(this.sqlFederationEngine.getResultSet());
            }
            case JDBC_PUSH_DOWN: {
                return this.jdbcPushDownExecutor.getResultSet(database, queryContext, statement, statements);
            }
        }
        return Optional.empty();
    }

    @Generated
    public DriverExecuteExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, DriverJDBCPushDownExecuteExecutor jdbcPushDownExecutor, DriverRawPushDownExecuteExecutor rawPushDownExecutor, SQLFederationEngine sqlFederationEngine, DriverTransactionSQLStatementExecutor transactionExecutor) {
        this.connection = connection;
        this.metaData = metaData;
        this.jdbcPushDownExecutor = jdbcPushDownExecutor;
        this.rawPushDownExecutor = rawPushDownExecutor;
        this.sqlFederationEngine = sqlFederationEngine;
        this.transactionExecutor = transactionExecutor;
    }

    public static enum ExecuteType {
        FEDERATION,
        JDBC_PUSH_DOWN,
        RAW_PUSH_DOWN;

    }
}

