/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;

public abstract class OrderByItemSegment
implements SQLSegment {
    private final int startIndex;
    private final int stopIndex;
    private final OrderDirection orderDirection;
    private final NullsOrderType nullsOrderType;

    public Optional<NullsOrderType> getNullsOrderType() {
        return Optional.ofNullable(this.nullsOrderType);
    }

    public NullsOrderType getNullsOrderType(DatabaseType databaseType) {
        if (null != this.nullsOrderType) {
            return this.nullsOrderType;
        }
        return new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getDefaultNullsOrderType().getResolvedOrderType(this.orderDirection.name());
    }

    @Generated
    public OrderByItemSegment(int startIndex, int stopIndex, OrderDirection orderDirection, NullsOrderType nullsOrderType) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.orderDirection = orderDirection;
        this.nullsOrderType = nullsOrderType;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }
}

