/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge.result.impl.memory;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public abstract class MemoryMergedResult<T extends ShardingSphereRule>
implements MergedResult {
    private static final Collection<Class<?>> INVALID_MEMORY_TYPES = new HashSet<Class>(Arrays.asList(Blob.class, Clob.class, Reader.class, InputStream.class, SQLXML.class));
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;
    private MemoryQueryResultRow currentResultSetRow;
    private boolean wasNull;

    protected MemoryMergedResult(T rule, ShardingSphereSchema schema, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        List<MemoryQueryResultRow> memoryQueryResultRows = this.init(rule, schema, sqlStatementContext, queryResults);
        this.memoryResultSetRows = memoryQueryResultRows.iterator();
        if (!memoryQueryResultRows.isEmpty()) {
            this.currentResultSetRow = memoryQueryResultRows.get(0);
        }
    }

    protected abstract List<MemoryQueryResultRow> init(T var1, ShardingSphereSchema var2, SQLStatementContext var3, List<QueryResult> var4) throws SQLException;

    @Override
    public final boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.currentResultSetRow = this.memoryResultSetRows.next();
            return true;
        }
        return false;
    }

    @Override
    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        ShardingSpherePreconditions.checkNotContains(INVALID_MEMORY_TYPES, type, () -> new SQLFeatureNotSupportedException(String.format("Get value from `%s`", type.getName())));
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException(String.format("Get input stream from `%s`", type));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Get Character stream");
    }

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }
}

