/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.firebird.jdbcurl;

import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBDriver;

public final class FirebirdConnectionPropertiesParser
implements ConnectionPropertiesParser {
    public ConnectionProperties parse(String url, String username, String catalog) {
        GDSType type = GDSFactory.getTypeForProtocol((String)url);
        String databaseURL = GDSFactory.getDatabasePath((GDSType)type, (String)url);
        DbAttachInfo dbAttachInfo = DbAttachInfo.parseConnectString((String)databaseURL);
        String attachObjectName = dbAttachInfo.getAttachObjectName();
        String databaseName = attachObjectName.contains("?") ? attachObjectName.split("\\?")[0] : attachObjectName;
        Properties queryProps = new Properties();
        queryProps.putAll((Map<?, ?>)FBDriver.normalizeProperties((String)url, (Properties)new Properties()));
        return new ConnectionProperties(dbAttachInfo.getServerName(), dbAttachInfo.getPortNumber(), databaseName, null, queryProps);
    }

    public String getDatabaseType() {
        return "Firebird";
    }
}

