/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.mysql.metadata.data.loader;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.database.connector.core.GlobalDataSourceRegistry;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.DialectMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.ColumnMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.ConstraintMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.IndexMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.datatype.DataTypeRegistry;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.TableType;

public final class MySQLMetaDataLoader
implements DialectMetaDataLoader {
    private static final String ORDER_BY_ORDINAL_POSITION = " ORDER BY ORDINAL_POSITION";
    private static final String TABLE_META_DATA_NO_ORDER = "SELECT TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_KEY, EXTRA, COLLATION_NAME, ORDINAL_POSITION, COLUMN_TYPE, IS_NULLABLE FROM information_schema.columns WHERE TABLE_SCHEMA=?";
    private static final String TABLE_META_DATA_SQL = "SELECT TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_KEY, EXTRA, COLLATION_NAME, ORDINAL_POSITION, COLUMN_TYPE, IS_NULLABLE FROM information_schema.columns WHERE TABLE_SCHEMA=? ORDER BY ORDINAL_POSITION";
    private static final String TABLE_META_DATA_SQL_IN_TABLES = "SELECT TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_KEY, EXTRA, COLLATION_NAME, ORDINAL_POSITION, COLUMN_TYPE, IS_NULLABLE FROM information_schema.columns WHERE TABLE_SCHEMA=? AND TABLE_NAME IN (%s) ORDER BY ORDINAL_POSITION";
    private static final String INDEX_META_DATA_SQL = "SELECT TABLE_NAME, INDEX_NAME, NON_UNIQUE, COLUMN_NAME FROM information_schema.statistics WHERE TABLE_SCHEMA=? and TABLE_NAME IN (%s) ORDER BY NON_UNIQUE, INDEX_NAME, SEQ_IN_INDEX";
    private static final String CONSTRAINT_META_DATA_SQL = "SELECT CONSTRAINT_NAME, TABLE_NAME, REFERENCED_TABLE_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE TABLE_NAME IN (%s) AND REFERENCED_TABLE_SCHEMA IS NOT NULL";
    private static final String VIEW_META_DATA_SQL = "SELECT TABLE_NAME FROM information_schema.VIEWS WHERE TABLE_SCHEMA=? AND TABLE_NAME IN (%s)";

    public Collection<SchemaMetaData> load(MetaDataLoaderMaterial material) throws SQLException {
        LinkedList<TableMetaData> tableMetaDataList = new LinkedList<TableMetaData>();
        Map<String, Collection<ColumnMetaData>> columnMetaDataMap = this.loadColumnMetaDataMap(material.getDataSource(), material.getActualTableNames());
        Set viewNames = columnMetaDataMap.isEmpty() ? Collections.emptySet() : this.loadViewNames(material.getDataSource(), columnMetaDataMap.keySet());
        Map indexMetaDataMap = columnMetaDataMap.isEmpty() ? Collections.emptyMap() : this.loadIndexMetaData(material.getDataSource(), columnMetaDataMap.keySet());
        Map constraintMetaDataMap = columnMetaDataMap.isEmpty() ? Collections.emptyMap() : this.loadConstraintMetaDataMap(material.getDataSource(), columnMetaDataMap.keySet());
        for (Map.Entry<String, Collection<ColumnMetaData>> entry : columnMetaDataMap.entrySet()) {
            Collection indexMetaDataList = indexMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList());
            Collection constraintMetaDataList = constraintMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList());
            tableMetaDataList.add(new TableMetaData(entry.getKey(), entry.getValue(), indexMetaDataList, constraintMetaDataList, viewNames.contains(entry.getKey()) ? TableType.VIEW : TableType.TABLE));
        }
        return Collections.singletonList(new SchemaMetaData(material.getDefaultSchemaName(), tableMetaDataList));
    }

    private Collection<String> loadViewNames(DataSource dataSource, Collection<String> tableNames) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getViewMetaDataSQL(tableNames));){
            String databaseName = "".equals(connection.getCatalog()) ? (String)GlobalDataSourceRegistry.getInstance().getCachedDatabaseTables().get(tableNames.iterator().next()) : connection.getCatalog();
            preparedStatement.setString(1, databaseName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
        }
        return result;
    }

    private String getViewMetaDataSQL(Collection<String> tableNames) {
        return String.format(VIEW_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<ConstraintMetaData>> loadConstraintMetaDataMap(DataSource dataSource, Collection<String> tables) throws SQLException {
        LinkedHashMap<String, Collection<ConstraintMetaData>> result = new LinkedHashMap<String, Collection<ConstraintMetaData>>(tables.size(), 1.0f);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getConstraintMetaDataSQL(tables));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                String tableName = resultSet.getString("TABLE_NAME");
                String referencedTableName = resultSet.getString("REFERENCED_TABLE_NAME");
                if (!result.containsKey(tableName)) {
                    result.put(tableName, new LinkedList());
                }
                ((Collection)result.get(tableName)).add(new ConstraintMetaData(constraintName, referencedTableName));
            }
        }
        return result;
    }

    private String getConstraintMetaDataSQL(Collection<String> tableNames) {
        return String.format(CONSTRAINT_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(DataSource dataSource, Collection<String> tables) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> result = new HashMap<String, Collection<ColumnMetaData>>(tables.size(), 1.0f);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(tables));){
            String databaseName = "".equals(connection.getCatalog()) ? (String)GlobalDataSourceRegistry.getInstance().getCachedDatabaseTables().get(tables.iterator().next()) : connection.getCatalog();
            preparedStatement.setString(1, databaseName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(resultSet);
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(columnMetaData);
                }
            }
        }
        return result;
    }

    private ColumnMetaData loadColumnMetaData(ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String dataType = resultSet.getString("DATA_TYPE");
        boolean primaryKey = "PRI".equalsIgnoreCase(resultSet.getString("COLUMN_KEY"));
        String extra = resultSet.getString("EXTRA");
        boolean generated = "auto_increment".equals(extra);
        String collationName = resultSet.getString("COLLATION_NAME");
        boolean caseSensitive = null != collationName && !collationName.endsWith("_ci");
        boolean visible = !"INVISIBLE".equalsIgnoreCase(extra);
        boolean unsigned = resultSet.getString("COLUMN_TYPE").toUpperCase().contains("UNSIGNED");
        boolean nullable = "YES".equals(resultSet.getString("IS_NULLABLE"));
        return new ColumnMetaData(columnName, DataTypeRegistry.getDataType((String)this.getDatabaseType(), (String)dataType).orElse(1111).intValue(), primaryKey, generated, caseSensitive, visible, unsigned, nullable);
    }

    private String getTableMetaDataSQL(Collection<String> tables) {
        return tables.isEmpty() ? TABLE_META_DATA_SQL : String.format(TABLE_META_DATA_SQL_IN_TABLES, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaData(DataSource dataSource, Collection<String> tableNames) throws SQLException {
        HashMap tableToIndex = new HashMap(tableNames.size(), 1.0f);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(tableNames));){
            String databaseName = "".equals(connection.getCatalog()) ? (String)GlobalDataSourceRegistry.getInstance().getCachedDatabaseTables().get(tableNames.iterator().next()) : connection.getCatalog();
            preparedStatement.setString(1, databaseName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String indexName = resultSet.getString("INDEX_NAME");
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!tableToIndex.containsKey(tableName)) {
                        tableToIndex.put(tableName, new HashMap());
                    }
                    Map indexMap = (Map)tableToIndex.get(tableName);
                    String columnName = resultSet.getString("COLUMN_NAME");
                    if (Strings.isNullOrEmpty((String)columnName)) continue;
                    if (indexMap.containsKey(indexName)) {
                        ((IndexMetaData)indexMap.get(indexName)).getColumns().add(columnName);
                        continue;
                    }
                    IndexMetaData indexMetaData = new IndexMetaData(indexName, new LinkedList<String>(Collections.singleton(columnName)));
                    indexMetaData.setUnique("0".equals(resultSet.getString("NON_UNIQUE")));
                    indexMap.put(indexName, indexMetaData);
                }
            }
        }
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>(tableToIndex.size(), 1.0f);
        for (Map.Entry entry : tableToIndex.entrySet()) {
            result.put((String)entry.getKey(), ((Map)entry.getValue()).values());
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> tableNames) {
        return String.format(INDEX_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

