/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection.transaction;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionManager;

public final class TransactionConnectionContext
implements AutoCloseable {
    private volatile String transactionType;
    private volatile boolean inTransaction;
    private volatile long beginMillis;
    private volatile boolean exceptionOccur;
    private volatile String readWriteSplitReplicaRoute;
    private AtomicReference<TransactionManager> transactionManager;

    public void beginTransaction(String transactionType, TransactionManager transactionManager) {
        this.transactionType = transactionType;
        this.inTransaction = true;
        this.transactionManager = new AtomicReference<TransactionManager>(transactionManager);
    }

    public boolean isDistributedTransactionStarted() {
        return this.isTransactionStarted() && ("XA".equals(this.transactionType) || "BASE".equals(this.transactionType));
    }

    public Optional<String> getTransactionType() {
        return Optional.ofNullable(this.transactionType);
    }

    public Optional<String> getReadWriteSplitReplicaRoute() {
        return Optional.ofNullable(this.readWriteSplitReplicaRoute);
    }

    public Optional<TransactionManager> getTransactionManager() {
        return null == this.transactionManager ? Optional.empty() : Optional.ofNullable(this.transactionManager.get());
    }

    public boolean isTransactionStarted() {
        return this.inTransaction;
    }

    @Override
    public void close() {
        this.transactionType = null;
        this.inTransaction = false;
        this.beginMillis = 0L;
        this.exceptionOccur = false;
        this.readWriteSplitReplicaRoute = null;
        this.transactionManager = null;
    }

    @Generated
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Generated
    public long getBeginMillis() {
        return this.beginMillis;
    }

    @Generated
    public boolean isExceptionOccur() {
        return this.exceptionOccur;
    }

    @Generated
    public void setBeginMillis(long beginMillis) {
        this.beginMillis = beginMillis;
    }

    @Generated
    public void setExceptionOccur(boolean exceptionOccur) {
        this.exceptionOccur = exceptionOccur;
    }

    @Generated
    public void setReadWriteSplitReplicaRoute(String readWriteSplitReplicaRoute) {
        this.readWriteSplitReplicaRoute = readWriteSplitReplicaRoute;
    }
}

