/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable.export;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.type.ral.queryable.show.ShowTableMetaDataStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowTableMetaDataExecutor
implements DistSQLQueryExecutor<ShowTableMetaDataStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    public Collection<String> getColumnNames(ShowTableMetaDataStatement sqlStatement) {
        return Arrays.asList("database_name", "table_name", "type", "name", "value");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowTableMetaDataStatement sqlStatement, ContextManager contextManager) {
        String defaultSchema = new DatabaseTypeRegistry(this.database.getProtocolType()).getDefaultSchemaName(this.database.getName());
        ShardingSphereSchema schema = this.database.getSchema(defaultSchema);
        return sqlStatement.getTableNames().stream().filter(arg_0 -> ((ShardingSphereSchema)schema).containsTable(arg_0)).map(each -> this.buildTableRows(this.database.getName(), schema, (String)each)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<LocalDataQueryResultRow> buildTableRows(String databaseName, ShardingSphereSchema schema, String tableName) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        ShardingSphereTable table = schema.getTable(tableName);
        result.addAll(table.getAllColumns().stream().map(each -> this.buildColumnRow(databaseName, tableName, (ShardingSphereColumn)each)).collect(Collectors.toList()));
        result.addAll(table.getAllIndexes().stream().map(each -> this.buildIndexRow(databaseName, tableName, (ShardingSphereIndex)each)).collect(Collectors.toList()));
        return result;
    }

    private LocalDataQueryResultRow buildColumnRow(String databaseName, String tableName, ShardingSphereColumn column) {
        return new LocalDataQueryResultRow(new Object[]{databaseName, tableName, "COLUMN", column.getName(), column});
    }

    private LocalDataQueryResultRow buildIndexRow(String databaseName, String tableName, ShardingSphereIndex index) {
        return new LocalDataQueryResultRow(new Object[]{databaseName, tableName, "INDEX", index.getName(), index});
    }

    public Class<ShowTableMetaDataStatement> getType() {
        return ShowTableMetaDataStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

