/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rul;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorConnectionContextAware;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.type.rul.sql.PreviewStatement;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CursorHeldSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.EmptyRuleException;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;
import org.apache.shardingsphere.sqlfederation.context.SQLFederationContext;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;

public final class PreviewExecutor
implements DistSQLQueryExecutor<PreviewStatement>,
DistSQLExecutorDatabaseAware,
DistSQLExecutorConnectionContextAware {
    private ShardingSphereDatabase database;
    private DistSQLConnectionContext connectionContext;

    public Collection<String> getColumnNames(PreviewStatement sqlStatement) {
        return Arrays.asList("data_source_name", "actual_sql");
    }

    public Collection<LocalDataQueryResultRow> getRows(PreviewStatement sqlStatement, ContextManager contextManager) {
        ShardingSphereMetaData metaData = contextManager.getMetaDataContexts().getMetaData();
        String toBePreviewedSQL = sqlStatement.getSql();
        SQLStatement toBePreviewedStatement = ((SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(this.database.getProtocolType()).parse(toBePreviewedSQL, false);
        HintValueContext hintValueContext = this.connectionContext.getQueryContext().getHintValueContext();
        hintValueContext.setSkipMetadataValidate(true);
        String currentDatabaseName = this.connectionContext.getQueryContext().getConnectionContext().getCurrentDatabaseName().orElse(null);
        SQLStatementContext toBePreviewedStatementContext = new SQLBindEngine(metaData, currentDatabaseName, hintValueContext).bind(toBePreviewedStatement);
        QueryContext queryContext = new QueryContext(toBePreviewedStatementContext, toBePreviewedSQL, Collections.emptyList(), hintValueContext, this.connectionContext.getQueryContext().getConnectionContext(), metaData);
        if (toBePreviewedStatementContext.getSqlStatement().getAttributes().findAttribute(CursorSQLStatementAttribute.class).isPresent() && toBePreviewedStatementContext instanceof CursorHeldSQLStatementContext) {
            this.setUpCursorDefinition((CursorHeldSQLStatementContext)toBePreviewedStatementContext);
        }
        ShardingSpherePreconditions.checkState((boolean)this.database.isComplete(), () -> new EmptyRuleException(this.database.getName()));
        String schemaName = this.getSchemaName(queryContext.getSqlStatementContext(), this.database);
        Collection<ExecutionUnit> executionUnits = this.getExecutionUnits(contextManager, schemaName, metaData, queryContext);
        return executionUnits.stream().map(each -> new LocalDataQueryResultRow(new Object[]{each.getDataSourceName(), each.getSqlUnit().getSql()})).collect(Collectors.toList());
    }

    private String getSchemaName(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(database.getName());
        return sqlStatementContext.getTablesContext().getSchemaName().orElse(defaultSchemaName);
    }

    private Collection<ExecutionUnit> getExecutionUnits(ContextManager contextManager, String schemaName, ShardingSphereMetaData metaData, QueryContext queryContext) {
        JDBCExecutor jdbcExecutor = new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), this.connectionContext.getQueryContext().getConnectionContext());
        SQLFederationEngine federationEngine = new SQLFederationEngine(this.database.getName(), schemaName, metaData, contextManager.getMetaDataContexts().getStatistics(), jdbcExecutor);
        if (federationEngine.decide(queryContext, metaData.getGlobalRuleMetaData())) {
            return this.getFederationExecutionUnits(queryContext, metaData, federationEngine);
        }
        return new KernelProcessor().generateExecutionContext(queryContext, metaData.getGlobalRuleMetaData(), metaData.getProps()).getExecutionUnits();
    }

    private void setUpCursorDefinition(CursorHeldSQLStatementContext toBePreviewedStatementContext) {
        Optional cursorNameSegment = ((CursorSQLStatementAttribute)toBePreviewedStatementContext.getSqlStatement().getAttributes().getAttribute(CursorSQLStatementAttribute.class)).getCursorName();
        if (!cursorNameSegment.isPresent()) {
            return;
        }
        String cursorName = ((CursorNameSegment)cursorNameSegment.get()).getIdentifier().getValue().toLowerCase();
        CursorStatementContext cursorStatementContext = (CursorStatementContext)this.connectionContext.getQueryContext().getConnectionContext().getCursorContext().getCursorStatementContexts().get(cursorName);
        Preconditions.checkNotNull((Object)cursorStatementContext, (String)"Cursor %s does not exist.", (Object)cursorName);
        toBePreviewedStatementContext.setCursorStatementContext(cursorStatementContext);
    }

    private Collection<ExecutionUnit> getFederationExecutionUnits(QueryContext queryContext, ShardingSphereMetaData metaData, SQLFederationEngine federationEngine) {
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(metaData);
        SQLFederationContext context = new SQLFederationContext(true, queryContext, metaData, ((ProxyDatabaseConnectionManager)this.connectionContext.getDatabaseConnectionManager()).getConnectionSession().getProcessId());
        federationEngine.executeQuery(prepareEngine, this.createPreviewCallback(sqlStatement), context);
        return context.getPreviewExecutionUnits();
    }

    private JDBCExecutorCallback<ExecuteResult> createPreviewCallback(SQLStatement sqlStatement) {
        return new JDBCExecutorCallback<ExecuteResult>(this.database.getProtocolType(), this.database.getResourceMetaData(), sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()){

            protected ExecuteResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return new JDBCStreamQueryResult(statement.executeQuery(sql));
            }

            protected Optional<ExecuteResult> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(ShardingSphereMetaData metaData) {
        int maxConnectionsSizePerQuery = (Integer)metaData.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine(JDBCDriverType.STATEMENT, maxConnectionsSizePerQuery, this.connectionContext.getDatabaseConnectionManager(), this.connectionContext.getExecutorStatementManager(), (StorageResourceOption)new StatementOption(false), this.database.getRuleMetaData().getRules(), metaData);
    }

    public Class<PreviewStatement> getType() {
        return PreviewStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setConnectionContext(DistSQLConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

