/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.tcl.local.type;

import java.sql.SQLException;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.ProxyBackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;

public final class CommitProxyBackendHandler
implements ProxyBackendHandler {
    private final TCLStatement sqlStatement;
    private final ConnectionSession connectionSession;
    private final ProxyBackendTransactionManager transactionManager;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public CommitProxyBackendHandler(TCLStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
        this.transactionManager = new ProxyBackendTransactionManager(connectionSession.getDatabaseConnectionManager());
        this.dialectDatabaseMetaData = new DatabaseTypeRegistry(connectionSession.getProtocolType()).getDialectDatabaseMetaData();
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        this.transactionManager.commit();
        return new UpdateResponseHeader((SQLStatement)(this.isReturnRollbackStatement() ? new RollbackStatement(this.connectionSession.getProtocolType()) : this.sqlStatement));
    }

    private boolean isReturnRollbackStatement() {
        return this.connectionSession.getConnectionContext().getTransactionContext().isExceptionOccur() && this.dialectDatabaseMetaData.getTransactionOption().isReturnRollbackStatementWhenCommitFailed();
    }
}

