/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.session;

import io.netty.util.AttributeMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.session.RequiredSessionVariableRecorder;
import org.apache.shardingsphere.proxy.backend.session.ServerPreparedStatementRegistry;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;

public final class ConnectionSession {
    private final DatabaseType protocolType;
    private volatile String currentDatabaseName;
    private volatile int connectionId;
    private final TransactionStatus transactionStatus;
    private final AttributeMap attributeMap;
    private volatile boolean autoCommit = true;
    private volatile boolean readOnly;
    private TransactionIsolationLevel defaultIsolationLevel;
    private TransactionIsolationLevel isolationLevel;
    private final ProxyDatabaseConnectionManager databaseConnectionManager;
    private final ExecutorStatementManager statementManager;
    private final ServerPreparedStatementRegistry serverPreparedStatementRegistry = new ServerPreparedStatementRegistry();
    private final AtomicReference<ConnectionContext> connectionContext = new AtomicReference();
    private final RequiredSessionVariableRecorder requiredSessionVariableRecorder = new RequiredSessionVariableRecorder();
    private volatile String processId;
    private QueryContext queryContext;

    public ConnectionSession(DatabaseType protocolType, AttributeMap attributeMap) {
        this.protocolType = protocolType;
        this.transactionStatus = new TransactionStatus();
        this.attributeMap = attributeMap;
        this.databaseConnectionManager = new ProxyDatabaseConnectionManager(this);
        this.statementManager = new JDBCBackendStatement();
    }

    public void setGrantee(Grantee grantee) {
        this.connectionContext.set(new ConnectionContext(this.databaseConnectionManager::getUsedDataSourceNames, grantee));
    }

    public void setCurrentDatabaseName(String currentDatabaseName) {
        if (null == currentDatabaseName || !currentDatabaseName.equals(this.currentDatabaseName)) {
            this.currentDatabaseName = currentDatabaseName;
            this.connectionContext.get().setCurrentDatabaseName(currentDatabaseName);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext.get();
    }

    public String getUsedDatabaseName() {
        return null == this.queryContext || this.queryContext.getUsedDatabaseNames().isEmpty() ? this.currentDatabaseName : (String)this.queryContext.getUsedDatabaseNames().iterator().next();
    }

    public Optional<TransactionIsolationLevel> getIsolationLevel() {
        return Optional.ofNullable(this.isolationLevel);
    }

    public void clearQueryContext() {
        this.queryContext = null;
    }

    @Generated
    public DatabaseType getProtocolType() {
        return this.protocolType;
    }

    @Generated
    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    @Generated
    public int getConnectionId() {
        return this.connectionId;
    }

    @Generated
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Generated
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Generated
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public TransactionIsolationLevel getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    @Generated
    public ProxyDatabaseConnectionManager getDatabaseConnectionManager() {
        return this.databaseConnectionManager;
    }

    @Generated
    public ExecutorStatementManager getStatementManager() {
        return this.statementManager;
    }

    @Generated
    public ServerPreparedStatementRegistry getServerPreparedStatementRegistry() {
        return this.serverPreparedStatementRegistry;
    }

    @Generated
    public RequiredSessionVariableRecorder getRequiredSessionVariableRecorder() {
        return this.requiredSessionVariableRecorder;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Generated
    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    @Generated
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Generated
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public void setDefaultIsolationLevel(TransactionIsolationLevel defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    @Generated
    public void setIsolationLevel(TransactionIsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public void setQueryContext(QueryContext queryContext) {
        this.queryContext = queryContext;
    }
}

