/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyServerConfiguration;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedMetaData;
import org.apache.shardingsphere.proxy.backend.util.YamlDatabaseConfigurationImportExecutor;

public final class MetaDataImportExecutor {
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final YamlDatabaseConfigurationImportExecutor databaseConfigImportExecutor;
    private final ContextManager contextManager;

    public MetaDataImportExecutor(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.databaseConfigImportExecutor = new YamlDatabaseConfigurationImportExecutor(contextManager);
    }

    public void importClusterConfigurations(ExportedMetaData exportedMetaData) {
        Map<String, YamlProxyDatabaseConfiguration> databaseConfigs = this.getYamlProxyDatabaseConfigurations(exportedMetaData);
        YamlProxyServerConfiguration yamlServerConfig = this.getYamlServerConfig(exportedMetaData);
        this.importServerConfiguration(yamlServerConfig);
        this.importDatabaseConfigurations(databaseConfigs.values());
    }

    private void importServerConfiguration(YamlProxyServerConfiguration yamlServerConfig) {
        if (null == yamlServerConfig) {
            return;
        }
        this.importGlobalRules(yamlServerConfig);
        this.importProps(yamlServerConfig);
    }

    private void importGlobalRules(YamlProxyServerConfiguration yamlServerConfig) {
        Collection rules = this.ruleConfigSwapperEngine.swapToRuleConfigurations(yamlServerConfig.getRules());
        for (RuleConfiguration each : rules) {
            this.contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService().alterGlobalRuleConfiguration(each);
        }
    }

    private void importProps(YamlProxyServerConfiguration yamlServerConfig) {
        this.contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService().alterProperties(yamlServerConfig.getProps());
    }

    private Map<String, YamlProxyDatabaseConfiguration> getYamlProxyDatabaseConfigurations(ExportedMetaData exportedMetaData) {
        return exportedMetaData.getDatabases().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((String)((String)entry.getValue()), YamlProxyDatabaseConfiguration.class), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlProxyServerConfiguration getYamlServerConfig(ExportedMetaData exportedMetaData) {
        return (YamlProxyServerConfiguration)YamlEngine.unmarshal((String)(exportedMetaData.getRules() + System.lineSeparator() + exportedMetaData.getProps()), YamlProxyServerConfiguration.class);
    }

    public void importDatabaseConfigurations(Collection<YamlProxyDatabaseConfiguration> databaseConfigs) {
        for (YamlProxyDatabaseConfiguration each : databaseConfigs) {
            this.databaseConfigImportExecutor.importDatabaseConfiguration(each);
        }
    }
}

