/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rql.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.type.rql.resource.ShowLogicalTablesStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.regex.RegexUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowLogicalTablesExecutor
implements DistSQLQueryExecutor<ShowLogicalTablesStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    @Override
    public Collection<String> getColumnNames(ShowLogicalTablesStatement sqlStatement) {
        if (new DatabaseTypeRegistry(this.database.getProtocolType()).getDialectDatabaseMetaData().getSchemaOption().isSchemaAvailable()) {
            return sqlStatement.isContainsFull() ? Arrays.asList("table_name", "table_type", "schema_name") : Arrays.asList("table_name", "schema_name");
        }
        return sqlStatement.isContainsFull() ? Arrays.asList("table_name", "table_type") : Collections.singleton("table_name");
    }

    @Override
    public Collection<LocalDataQueryResultRow> getRows(ShowLogicalTablesStatement sqlStatement, ContextManager contextManager) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(this.database.getProtocolType()).getDialectDatabaseMetaData();
        String schemaName = dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().orElse(this.database.getName());
        if (null == this.database.getSchema(schemaName)) {
            return Collections.emptyList();
        }
        return this.getTables(schemaName, sqlStatement).stream().map(each -> this.getRow(schemaName, (ShardingSphereTable)each, sqlStatement)).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow getRow(String schemaName, ShardingSphereTable table, ShowLogicalTablesStatement sqlStatement) {
        if (new DatabaseTypeRegistry(this.database.getProtocolType()).getDialectDatabaseMetaData().getSchemaOption().isSchemaAvailable()) {
            return sqlStatement.isContainsFull() ? new LocalDataQueryResultRow(new Object[]{table.getName(), table.getType(), schemaName}) : new LocalDataQueryResultRow(new Object[]{table.getName(), schemaName});
        }
        return sqlStatement.isContainsFull() ? new LocalDataQueryResultRow(new Object[]{table.getName(), table.getType()}) : new LocalDataQueryResultRow(new Object[]{table.getName()});
    }

    private Collection<ShardingSphereTable> getTables(String schemaName, ShowLogicalTablesStatement sqlStatement) {
        Collection tables = this.database.getSchema(schemaName).getAllTables();
        Collection<ShardingSphereTable> filteredTables = this.filterByLike(tables, sqlStatement);
        return filteredTables.stream().sorted(Comparator.comparing(ShardingSphereTable::getName)).collect(Collectors.toList());
    }

    private Collection<ShardingSphereTable> filterByLike(Collection<ShardingSphereTable> tables, ShowLogicalTablesStatement sqlStatement) {
        Optional<Pattern> likePattern = this.getLikePattern(sqlStatement);
        return likePattern.isPresent() ? (Collection)tables.stream().filter(each -> ((Pattern)likePattern.get()).matcher(each.getName()).matches()).collect(Collectors.toList()) : tables;
    }

    private Optional<Pattern> getLikePattern(ShowLogicalTablesStatement sqlStatement) {
        return sqlStatement.getLikePattern().map(optional -> Pattern.compile(RegexUtils.convertLikePatternToRegex((String)optional), 2));
    }

    @Override
    public Class<ShowLogicalTablesStatement> getType() {
        return ShowLogicalTablesStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

