/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager.database;

import java.util.Collections;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;

public final class DatabaseMetaDataManager {
    private final MetaDataContexts metaDataContexts;
    private final MetaDataPersistFacade metaDataPersistFacade;

    public synchronized void addDatabase(String databaseName) {
        if (this.metaDataContexts.getMetaData().containsDatabase(databaseName)) {
            return;
        }
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(Collections.emptyMap(), (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps());
        this.metaDataContexts.getMetaData().addDatabase(databaseName, protocolType, this.metaDataContexts.getMetaData().getProps());
        this.metaDataContexts.update(this.metaDataContexts.getMetaData(), this.metaDataPersistFacade);
    }

    public synchronized void dropDatabase(String databaseName) {
        if (!this.metaDataContexts.getMetaData().containsDatabase(databaseName)) {
            return;
        }
        this.metaDataContexts.getMetaData().dropDatabase(this.metaDataContexts.getMetaData().getDatabase(databaseName).getName());
    }

    public synchronized void addSchema(String databaseName, String schemaName) {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        if (database.containsSchema(schemaName)) {
            return;
        }
        database.addSchema(new ShardingSphereSchema(schemaName, database.getProtocolType()));
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public synchronized void dropSchema(String databaseName, String schemaName) {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        if (!database.containsSchema(schemaName)) {
            return;
        }
        database.dropSchema(schemaName);
        if (database.getSchema(schemaName).getAllTables().stream().anyMatch(each -> TableRefreshUtils.isSingleTable(each.getName(), database))) {
            database.reloadRules();
        }
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public synchronized void renameSchema(String databaseName, String schemaName, String renamedSchemaName) {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        ShardingSphereSchema schema = database.getSchema(schemaName);
        ShardingSphereSchema renamedSchema = new ShardingSphereSchema(renamedSchemaName, database.getProtocolType(), schema.getAllTables(), schema.getAllViews());
        database.addSchema(renamedSchema);
        database.dropSchema(schemaName);
        database.reloadRules();
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public synchronized void alterTable(String databaseName, String schemaName, ShardingSphereTable toBeAlteredTable) {
        this.alterTableOrView(databaseName, schemaName, toBeAlteredTable.getName(), schema -> schema.putTable(toBeAlteredTable));
    }

    public synchronized void alterView(String databaseName, String schemaName, ShardingSphereView toBeAlteredView) {
        this.alterTableOrView(databaseName, schemaName, toBeAlteredView.getName(), schema -> schema.putView(toBeAlteredView));
    }

    private void alterTableOrView(String databaseName, String schemaName, String tableOrViewName, Consumer<ShardingSphereSchema> alterAction) {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData();
        if (!metaData.getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        alterAction.accept(database.getSchema(schemaName));
        if (TableRefreshUtils.isSingleTable(tableOrViewName, database)) {
            database.reloadRules();
        }
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public synchronized void dropTable(String databaseName, String schemaName, String toBeDroppedTableName) {
        this.dropTableOrView(databaseName, schemaName, toBeDroppedTableName, true);
    }

    public synchronized void dropView(String databaseName, String schemaName, String toBeDroppedViewName) {
        this.dropTableOrView(databaseName, schemaName, toBeDroppedViewName, false);
    }

    private void dropTableOrView(String databaseName, String schemaName, String toBeDroppedTableOrViewName, boolean isTable) {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        if (!database.containsSchema(schemaName)) {
            return;
        }
        if (isTable) {
            database.getSchema(schemaName).removeTable(toBeDroppedTableOrViewName);
        } else {
            database.getSchema(schemaName).removeView(toBeDroppedTableOrViewName);
        }
        database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.remove(schemaName, toBeDroppedTableOrViewName));
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(this.metaDataContexts.getMetaData().getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    @Generated
    public DatabaseMetaDataManager(MetaDataContexts metaDataContexts, MetaDataPersistFacade metaDataPersistFacade) {
        this.metaDataContexts = metaDataContexts;
        this.metaDataPersistFacade = metaDataPersistFacade;
    }
}

