/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.connection.dialect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;

public final class H2XAConnectionWrapper
implements XAConnectionWrapper {
    private static final int XA_DATA_SOURCE_TRACE_TYPE_ID = 13;
    private Class<Connection> jdbcConnectionClass;
    private Constructor<?> xaConnectionConstructor;
    private Method nextIdMethod;
    private Object dataSourceFactory;

    @Override
    public XAConnection wrap(XADataSource xaDataSource, Connection connection) throws SQLException {
        return this.createXAConnection(connection.unwrap(this.jdbcConnectionClass));
    }

    public void init(Properties props) {
        this.loadReflection();
    }

    private void loadReflection() {
        this.jdbcConnectionClass = this.getJDBCConnectionClass();
        this.xaConnectionConstructor = this.getXAConnectionConstructor();
        this.nextIdMethod = this.getNextIdMethod();
        this.dataSourceFactory = this.createDataSourceFactory();
    }

    private Class<Connection> getJDBCConnectionClass() {
        return Class.forName("org.h2.jdbc.JdbcConnection");
    }

    private Constructor<?> getXAConnectionConstructor() {
        Constructor<?> result = Class.forName("org.h2.jdbcx.JdbcXAConnection").getDeclaredConstructor(Class.forName("org.h2.jdbcx.JdbcDataSourceFactory"), Integer.TYPE, Class.forName("org.h2.jdbc.JdbcConnection"));
        result.setAccessible(true);
        return result;
    }

    private Method getNextIdMethod() {
        Method result = Class.forName("org.h2.message.TraceObject").getDeclaredMethod("getNextId", Integer.TYPE);
        result.setAccessible(true);
        return result;
    }

    private Object createDataSourceFactory() {
        return Class.forName("org.h2.jdbcx.JdbcDataSourceFactory").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private XAConnection createXAConnection(Connection connection) {
        return (XAConnection)this.xaConnectionConstructor.newInstance(this.dataSourceFactory, this.nextIdMethod.invoke(null, 13), connection);
    }

    public String getDatabaseType() {
        return "H2";
    }
}

