/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.version.DialectProtocolVersionOption;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;

public final class DatabaseProtocolServerInfo {
    private static final String SERVER_INFORMATION_PATTERN = "%s-ShardingSphere-Proxy %s";
    private static final Map<String, String> SERVER_INFORMATION_MAP = new ConcurrentHashMap<String, String>();

    public static void setProtocolVersion(String databaseName, String protocolVersion) {
        SERVER_INFORMATION_MAP.put(databaseName, String.format(SERVER_INFORMATION_PATTERN, protocolVersion, CommonConstants.PROXY_VERSION.get()));
    }

    public static String getProtocolVersion(String databaseName, DatabaseType databaseType) {
        return null == databaseName ? DatabaseProtocolServerInfo.getDefaultProtocolVersion(databaseType) : SERVER_INFORMATION_MAP.getOrDefault(databaseName, DatabaseProtocolServerInfo.getDefaultProtocolVersion(databaseType));
    }

    public static String getDefaultProtocolVersion(DatabaseType databaseType) {
        DialectProtocolVersionOption protocolVersionOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getProtocolVersionOption();
        return String.format(SERVER_INFORMATION_PATTERN, protocolVersionOption.getDefaultVersion(), CommonConstants.PROXY_VERSION.get());
    }

    @Generated
    private DatabaseProtocolServerInfo() {
    }
}

