/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.type.database.metadata.rule;

import lombok.Generated;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.NodePathEntity;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleItem;

@NodePathEntity(value="${database}/rules/${ruleType}/${databaseRuleItem}")
public final class DatabaseRuleNodePath
implements NodePath {
    private final DatabaseMetaDataNodePath database;
    private final String ruleType;
    private final DatabaseRuleItem databaseRuleItem;

    public DatabaseRuleNodePath(String databaseName, String ruleType, DatabaseRuleItem databaseRuleItem) {
        this.database = new DatabaseMetaDataNodePath(databaseName);
        this.ruleType = ruleType;
        this.databaseRuleItem = databaseRuleItem;
    }

    public static NodePathSearchCriteria createRuleTypeSearchCriteria(String databaseName) {
        return new NodePathSearchCriteria(new DatabaseRuleNodePath(databaseName, "([\\w-]+)", null), true, 1);
    }

    public static NodePathSearchCriteria createRuleItemNameSearchCriteria(String databaseName, String ruleType, String ruleItemType) {
        return new NodePathSearchCriteria(new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(ruleItemType, "([\\w-]+(?:[:.][\\w-]+)*)")), true, 1);
    }

    public static boolean isRuleTypePath(String databaseName, String path) {
        return NodePathSearcher.find(path, new NodePathSearchCriteria(new DatabaseRuleNodePath(databaseName, "([\\w-]+)", null), false, 1)).isPresent();
    }

    public static boolean isNamedRuleItemPath(String databaseName, String ruleType, String ruleItemType, String path) {
        return NodePathSearcher.find(path, new NodePathSearchCriteria(new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(ruleItemType, "([\\w-]+(?:[:.][\\w-]+)*)")), false, 1)).isPresent();
    }

    public static boolean isUniqueRuleItemPath(String databaseName, String ruleType, String ruleItemType, String path) {
        return NodePathSearcher.isMatchedPath(path, new NodePathSearchCriteria(new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(ruleItemType, null)), false, 0));
    }

    @Generated
    public DatabaseMetaDataNodePath getDatabase() {
        return this.database;
    }

    @Generated
    public String getRuleType() {
        return this.ruleType;
    }

    @Generated
    public DatabaseRuleItem getDatabaseRuleItem() {
        return this.databaseRuleItem;
    }
}

