/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.constant;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;

public enum FirebirdArchType {
    ARCH_GENERIC(1, ""),
    ARCH_SUN(3, "SO"),
    ARCH_SUN4(8, "S4"),
    ARCH_SUNX86(9, "SI"),
    ARCH_HPUX(10, "HU"),
    ARCH_RT(14, "PA"),
    ARCH_INTEL_32(29, "WI"),
    ARCH_LINUX_LOONG(36, "LL"),
    ARCH_LINUX(36, "LI"),
    ARCH_FREEBSD(37, "FB"),
    ARCH_NETBSD(38, "NB"),
    ARCH_DARWIN_PPC(39, "UP"),
    ARCH_WINNT_64(40, "WI"),
    ARCH_DARWIN_X64_ARM(41, "UA"),
    ARCH_DARWIN_X64(41, "UI"),
    ARCH_DARWIN_PPC64(42, "UP"),
    ARCH_ARM(43, "NP"),
    ARCH_MAX(44, "");

    public static final FirebirdArchType ARCHITECTURE;
    private static final Map<Integer, FirebirdArchType> FIREBIRD_ARCH_TYPE_CACHE;
    private final int code;
    private final String identifier;

    public static FirebirdArchType valueOf(int code) {
        FirebirdArchType result = FIREBIRD_ARCH_TYPE_CACHE.get(code);
        Preconditions.checkNotNull((Object)((Object)result), (String)"Cannot find '%d' in arch type", (int)code);
        return result;
    }

    public static boolean isValid(FirebirdArchType arch) {
        return arch == ARCH_GENERIC || arch == ARCHITECTURE;
    }

    @Generated
    private FirebirdArchType(int code, String identifier) {
        this.code = code;
        this.identifier = identifier;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    static {
        FIREBIRD_ARCH_TYPE_CACHE = new HashMap<Integer, FirebirdArchType>();
        for (FirebirdArchType each : FirebirdArchType.values()) {
            FIREBIRD_ARCH_TYPE_CACHE.put(each.code, each);
        }
        if (SystemUtils.IS_OS_SUN_OS) {
            switch (SystemUtils.OS_ARCH.toLowerCase()) {
                case "sparc": {
                    ARCHITECTURE = ARCH_SUN4;
                    break;
                }
                case "i386": 
                case "amd64": {
                    ARCHITECTURE = ARCH_SUNX86;
                    break;
                }
                default: {
                    ARCHITECTURE = ARCH_SUN;
                    break;
                }
            }
        } else if (SystemUtils.IS_OS_HP_UX) {
            ARCHITECTURE = ARCH_HPUX;
        } else if (SystemUtils.IS_OS_AIX) {
            ARCHITECTURE = ARCH_RT;
        } else if (SystemUtils.IS_OS_LINUX) {
            ARCHITECTURE = SystemUtils.OS_ARCH.toLowerCase().contains("loong") ? ARCH_LINUX_LOONG : ARCH_LINUX;
        } else if (SystemUtils.IS_OS_FREE_BSD) {
            ARCHITECTURE = ARCH_FREEBSD;
        } else if (SystemUtils.IS_OS_NET_BSD) {
            ARCHITECTURE = ARCH_NETBSD;
        } else if (SystemUtils.IS_OS_MAC || SystemUtils.OS_NAME.toLowerCase().contains("darwin")) {
            switch (SystemUtils.OS_ARCH.toLowerCase()) {
                case "ppc": 
                case "powerpc": {
                    ARCHITECTURE = ARCH_DARWIN_PPC;
                    break;
                }
                case "ppc64": {
                    ARCHITECTURE = ARCH_DARWIN_PPC64;
                    break;
                }
                case "arm": 
                case "aarch64": 
                case "aarch32": {
                    ARCHITECTURE = ARCH_DARWIN_X64_ARM;
                    break;
                }
                default: {
                    ARCHITECTURE = ARCH_DARWIN_X64;
                    break;
                }
            }
        } else {
            ARCHITECTURE = SystemUtils.IS_OS_WINDOWS && "amd64".equalsIgnoreCase(SystemUtils.OS_ARCH) ? ARCH_WINNT_64 : ("i386".equalsIgnoreCase(SystemUtils.OS_ARCH) ? ARCH_INTEL_32 : (Stream.of("arm", "aarch64", "aarch32").anyMatch(SystemUtils.OS_ARCH::equalsIgnoreCase) ? ARCH_ARM : ARCH_GENERIC));
        }
    }
}

