/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.binary.BinaryColumnType;

public enum FirebirdBinaryColumnType implements BinaryColumnType
{
    TEXT(452, 255),
    VARYING(448, 255),
    LEGACY_TEXT(452, 255),
    LEGACY_VARYING(448, 255),
    SHORT(500, 2),
    LONG(496, 4),
    FLOAT(482, 4),
    DOUBLE(480, 8),
    D_FLOAT(530, 8),
    TIMESTAMP(510, 8),
    BLOB(520, 8),
    ARRAY(540, 255),
    QUAD(550, 4),
    TIME(560, 4),
    DATE(570, 4),
    INT64(580, 8),
    NUMERIC(580, 8, 1),
    DECIMAL(580, 8, 2),
    TIMESTAMP_TZ_EX(32748, 10),
    TIME_TZ_EX(32750, 6),
    INT128(32752, 16),
    TIMESTAMP_TZ(32754, 10),
    TIME_TZ(32756, 6),
    DEC16(32760, 2),
    DEC34(32762, 4),
    BOOLEAN(32764, 1),
    NULL(32766, 0);

    private static final Map<Integer, FirebirdBinaryColumnType> JDBC_TYPE_AND_COLUMN_TYPE_MAP;
    private static final Map<Integer, FirebirdBinaryColumnType> BLR_TYPE_AND_COLUMN_TYPE_MAP;
    private static final Map<Integer, FirebirdBinaryColumnType> VALUE_AND_COLUMN_TYPE_MAP;
    private final int value;
    private final int length;
    private final int subtype;

    private FirebirdBinaryColumnType(int value, int length) {
        this.value = value;
        this.length = length;
        this.subtype = 0;
    }

    public static FirebirdBinaryColumnType valueOfJDBCType(int jdbcType) {
        Preconditions.checkArgument((boolean)JDBC_TYPE_AND_COLUMN_TYPE_MAP.containsKey(jdbcType), (String)"Can not find JDBC type `%d` in column type", (int)jdbcType);
        return JDBC_TYPE_AND_COLUMN_TYPE_MAP.get(jdbcType);
    }

    public static FirebirdBinaryColumnType valueOfBLRType(int blrType) {
        Preconditions.checkArgument((boolean)BLR_TYPE_AND_COLUMN_TYPE_MAP.containsKey(blrType), (String)"Can not find BLR type `%d` in column type", (int)blrType);
        return BLR_TYPE_AND_COLUMN_TYPE_MAP.get(blrType);
    }

    public static FirebirdBinaryColumnType valueOf(int value) {
        Preconditions.checkArgument((boolean)VALUE_AND_COLUMN_TYPE_MAP.containsKey(value), (String)"Can not find value `%d` in column type", (int)value);
        return VALUE_AND_COLUMN_TYPE_MAP.get(value);
    }

    @Generated
    private FirebirdBinaryColumnType(int value, int length, int subtype) {
        this.value = value;
        this.length = length;
        this.subtype = subtype;
    }

    @Generated
    public int getValue() {
        return this.value;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public int getSubtype() {
        return this.subtype;
    }

    static {
        JDBC_TYPE_AND_COLUMN_TYPE_MAP = new HashMap<Integer, FirebirdBinaryColumnType>(FirebirdBinaryColumnType.values().length, 1.0f);
        BLR_TYPE_AND_COLUMN_TYPE_MAP = new HashMap<Integer, FirebirdBinaryColumnType>(FirebirdBinaryColumnType.values().length, 1.0f);
        VALUE_AND_COLUMN_TYPE_MAP = new HashMap<Integer, FirebirdBinaryColumnType>(FirebirdBinaryColumnType.values().length, 1.0f);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-6, SHORT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(5, SHORT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(4, LONG);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-5, INT64);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(6, FLOAT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(7, FLOAT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(8, DOUBLE);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2, NUMERIC);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(3, DECIMAL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(1, VARYING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(12, VARYING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-1, BLOB);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(91, DATE);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(92, TIME);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(93, TIMESTAMP);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-2, TEXT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-3, VARYING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-4, BLOB);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(0, NULL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2004, BLOB);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(16, BOOLEAN);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2003, ARRAY);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2013, TIME_TZ);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2014, TIMESTAMP_TZ);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(38, VARYING);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(15, TEXT);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(14, LEGACY_TEXT);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(37, LEGACY_VARYING);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(27, DOUBLE);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(10, FLOAT);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(11, D_FLOAT);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(12, DATE);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(13, TIME);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(35, TIMESTAMP);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(9, BLOB);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(8, LONG);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(7, SHORT);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(16, INT64);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(23, BOOLEAN);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(24, DEC16);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(25, DEC34);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(26, INT128);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(29, TIMESTAMP_TZ);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(28, TIME_TZ);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(31, TIMESTAMP_TZ_EX);
        BLR_TYPE_AND_COLUMN_TYPE_MAP.put(30, TIME_TZ_EX);
        for (FirebirdBinaryColumnType each : FirebirdBinaryColumnType.values()) {
            VALUE_AND_COLUMN_TYPE_MAP.put(each.value, each);
        }
    }
}

