/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.generic;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.binary.BinaryCell;
import org.apache.shardingsphere.database.protocol.binary.BinaryRow;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdFetchResponsePacket
extends FirebirdPacket {
    private final int status;
    private final int count;
    private final BinaryRow row;

    @Override
    protected void write(FirebirdPacketPayload payload) {
        payload.writeInt4(FirebirdCommandPacketType.FETCH_RESPONSE.getValue());
        payload.writeInt4(this.status);
        payload.writeInt4(this.count);
        FirebirdFetchResponsePacket.writeRowData(payload, this.row);
    }

    static void writeRowData(FirebirdPacketPayload payload, BinaryRow row) {
        if (row == null) {
            return;
        }
        int nullBitsStartIndex = payload.getByteBuf().writerIndex();
        int nullBits = (row.getCells().size() + 7) / 8;
        nullBits += 4 - nullBits & 3;
        payload.getByteBuf().writeZero(nullBits);
        int i = 0;
        for (BinaryCell cell : row.getCells()) {
            if (null != cell.getData()) {
                FirebirdBinaryProtocolValue type = FirebirdBinaryProtocolValueFactory.getBinaryProtocolValue(cell.getColumnType());
                type.write(payload, cell.getData());
            } else {
                int nullBitsIndex = nullBitsStartIndex + i / 8;
                byte nullBitsByte = payload.getByteBuf().getByte(nullBitsIndex);
                payload.getByteBuf().setByte(nullBitsIndex, nullBitsByte | 1 << i % 8);
            }
            ++i;
        }
    }

    public static FirebirdFetchResponsePacket getFetchRowPacket(BinaryRow row) {
        return new FirebirdFetchResponsePacket(0, 1, row);
    }

    public static FirebirdFetchResponsePacket getFetchNoMoreRowsPacket() {
        return new FirebirdFetchResponsePacket(100, 0, null);
    }

    public static FirebirdFetchResponsePacket getFetchEndPacket() {
        return new FirebirdFetchResponsePacket(0, 0, null);
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public BinaryRow getRow() {
        return this.row;
    }

    @Generated
    public FirebirdFetchResponsePacket(int status, int count, BinaryRow row) {
        this.status = status;
        this.count = count;
        this.row = row;
    }
}

