/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.handshake;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdArchType;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdAuthenticationMethod;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdProtocol;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.handshake.FirebirdAcceptDataPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdAcceptPacket
extends FirebirdPacket {
    private static final int BATCH_SEND = 3;
    private static final int COMPRESS = 256;
    private static final int LAZY_SEND = 5;
    private static final int MASK = 255;
    private static final int OUT_OF_BAND = 4;
    private FirebirdCommandPacketType opCode = FirebirdCommandPacketType.ACCEPT;
    private FirebirdProtocol protocol;
    private FirebirdAcceptDataPacket acceptDataPacket;

    public FirebirdAcceptPacket(List<FirebirdProtocol> userProtocols) {
        this.protocol = userProtocols.remove(0);
        for (FirebirdProtocol protocol : userProtocols) {
            if (!FirebirdArchType.isValid(protocol.getArch()) || protocol.getWeight() < this.protocol.getWeight()) continue;
            this.protocol = protocol;
        }
    }

    public void setAcceptDataPacket(byte[] salt, String publicKey, FirebirdAuthenticationMethod plugin, int authenticated, String keys) {
        this.acceptDataPacket = new FirebirdAcceptDataPacket(salt, publicKey, plugin, authenticated, keys);
        this.opCode = FirebirdCommandPacketType.ACCEPT_DATA;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
        payload.writeInt4(this.opCode.getValue());
        payload.writeInt4(this.protocol.getVersion().getCode());
        payload.writeInt4(this.protocol.getArch().getCode());
        int type = Math.min(this.protocol.getMaxType() & 0xFF, 5);
        int compress = this.protocol.getMaxType() & 0x100;
        payload.writeInt4(type | compress);
        if (null != this.acceptDataPacket) {
            this.acceptDataPacket.write(payload);
        }
    }

    @Generated
    public FirebirdCommandPacketType getOpCode() {
        return this.opCode;
    }

    @Generated
    public FirebirdProtocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public FirebirdAcceptDataPacket getAcceptDataPacket() {
        return this.acceptDataPacket;
    }
}

