/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributesBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.KeyValue;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Value;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.ValueType;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    public static Attributes applyAttributesLimit(Attributes attributes, int countLimit, int lengthLimit) {
        if (attributes.isEmpty() || attributes.size() <= countLimit) {
            if (lengthLimit == Integer.MAX_VALUE) {
                return attributes;
            }
            boolean allValidLength = AttributeUtil.allMatch(attributes.asMap().values(), value -> AttributeUtil.isValidLength(value, lengthLimit));
            if (allValidLength) {
                return attributes;
            }
        }
        AttributesBuilder result = Attributes.builder();
        int i = 0;
        for (Map.Entry<AttributeKey<?>, Object> entry : attributes.asMap().entrySet()) {
            if (i >= countLimit) break;
            result.put(entry.getKey(), AttributeUtil.applyAttributeLengthLimit(entry.getValue(), lengthLimit));
            ++i;
        }
        return result.build();
    }

    private static boolean isValidLength(Object value, int lengthLimit) {
        if (value instanceof List) {
            return AttributeUtil.allMatch((List)value, entry -> AttributeUtil.isValidLength(entry, lengthLimit));
        }
        if (value instanceof String) {
            return ((String)value).length() < lengthLimit;
        }
        if (value instanceof Value) {
            return AttributeUtil.isValidLengthValue((Value)value, lengthLimit);
        }
        return true;
    }

    private static boolean isValidLengthValue(Value<?> value, int lengthLimit) {
        ValueType type = value.getType();
        if (type == ValueType.STRING) {
            return ((String)value.getValue()).length() < lengthLimit;
        }
        if (type == ValueType.BYTES) {
            ByteBuffer buffer = (ByteBuffer)value.getValue();
            return buffer.remaining() <= lengthLimit;
        }
        if (type == ValueType.ARRAY) {
            List array = (List)value.getValue();
            return AttributeUtil.allMatch(array, element -> AttributeUtil.isValidLengthValue(element, lengthLimit));
        }
        if (type == ValueType.KEY_VALUE_LIST) {
            List kvList = (List)value.getValue();
            return AttributeUtil.allMatch(kvList, kv -> AttributeUtil.isValidLengthValue(kv.getValue(), lengthLimit));
        }
        return true;
    }

    private static <T> boolean allMatch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T value : iterable) {
            if (predicate.test(value)) continue;
            return false;
        }
        return true;
    }

    public static Object applyAttributeLengthLimit(Object value, int lengthLimit) {
        if (lengthLimit == Integer.MAX_VALUE) {
            return value;
        }
        if (value instanceof List) {
            List values2 = (List)value;
            ArrayList<Object> response = new ArrayList<Object>(values2.size());
            for (Object entry : values2) {
                response.add(AttributeUtil.applyAttributeLengthLimit(entry, lengthLimit));
            }
            return response;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.length() < lengthLimit ? value : str.substring(0, lengthLimit);
        }
        if (value instanceof Value) {
            return AttributeUtil.applyValueLengthLimit((Value)value, lengthLimit);
        }
        return value;
    }

    private static Value<?> applyValueLengthLimit(Value<?> value, int lengthLimit) {
        ValueType type = value.getType();
        if (type == ValueType.STRING) {
            String str = (String)value.getValue();
            if (str.length() <= lengthLimit) {
                return value;
            }
            return Value.of(str.substring(0, lengthLimit));
        }
        if (type == ValueType.BYTES) {
            ByteBuffer buffer = (ByteBuffer)value.getValue();
            int length = buffer.remaining();
            if (length <= lengthLimit) {
                return value;
            }
            byte[] truncated = new byte[lengthLimit];
            buffer.get(truncated);
            return Value.of(truncated);
        }
        if (type == ValueType.ARRAY) {
            List array = (List)value.getValue();
            boolean allValidLength = AttributeUtil.allMatch(array, element -> AttributeUtil.isValidLengthValue(element, lengthLimit));
            if (allValidLength) {
                return value;
            }
            ArrayList result = new ArrayList(array.size());
            for (Value element2 : array) {
                result.add(AttributeUtil.applyValueLengthLimit(element2, lengthLimit));
            }
            return Value.of(result);
        }
        if (type == ValueType.KEY_VALUE_LIST) {
            List kvList = (List)value.getValue();
            boolean allValidLength = AttributeUtil.allMatch(kvList, kv -> AttributeUtil.isValidLengthValue(kv.getValue(), lengthLimit));
            if (allValidLength) {
                return value;
            }
            ArrayList<KeyValue> result = new ArrayList<KeyValue>(kvList.size());
            for (KeyValue kv2 : kvList) {
                result.add(KeyValue.of(kv2.getKey(), AttributeUtil.applyValueLengthLimit(kv2.getValue(), lengthLimit)));
            }
            return Value.of(result.toArray(new KeyValue[0]));
        }
        return value;
    }
}

