/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacket;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacketType;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.MySQLCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.mysql.command.MySQLCommandPacketFactory;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.proxy.frontend.mysql.err.MySQLErrorPacketFactory;

public final class MySQLCommandExecuteEngine
implements CommandExecuteEngine {
    public MySQLCommandPacketType getCommandPacketType(PacketPayload payload) {
        return MySQLCommandPacketType.valueOf((int)((MySQLPacketPayload)payload).readInt1());
    }

    public MySQLCommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, ConnectionSession connectionSession) {
        return MySQLCommandPacketFactory.newInstance((MySQLCommandPacketType)type, (MySQLPacketPayload)payload, connectionSession);
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, ConnectionSession connectionSession) throws SQLException {
        return MySQLCommandExecutorFactory.newInstance((MySQLCommandPacketType)type, packet, connectionSession);
    }

    public MySQLPacket getErrorPacket(Exception cause) {
        return MySQLErrorPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket> getOtherPacket(ConnectionSession connectionSession) {
        return Optional.empty();
    }

    public void writeQueryData(ChannelHandlerContext context, ProxyDatabaseConnectionManager databaseConnectionManager, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        if (ResponseType.QUERY != queryCommandExecutor.getResponseType() || !context.channel().isActive()) {
            return;
        }
        int count = 0;
        int flushThreshold = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_FLUSH_THRESHOLD);
        while (queryCommandExecutor.next()) {
            databaseConnectionManager.getConnectionResourceLock().doAwait(context);
            DatabasePacket dataValue = queryCommandExecutor.getQueryRowPacket();
            context.write((Object)dataValue);
            if (flushThreshold != ++count) continue;
            context.flush();
            count = 0;
        }
        context.write((Object)new MySQLEofPacket(ServerStatusFlagCalculator.calculateFor(databaseConnectionManager.getConnectionSession(), true)));
    }
}

