/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.syntax.column.ColumnNotFoundException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;

public final class MySQLComStmtPrepareParameterMarkerExtractor {
    public static List<ShardingSphereColumn> findColumnsOfParameterMarkers(SQLStatement sqlStatement, ShardingSphereSchema schema) {
        return sqlStatement instanceof InsertStatement && ((InsertStatement)sqlStatement).getTable().isPresent() ? MySQLComStmtPrepareParameterMarkerExtractor.findColumnsOfParameterMarkersForInsert((InsertStatement)sqlStatement, schema) : Collections.emptyList();
    }

    private static List<ShardingSphereColumn> findColumnsOfParameterMarkersForInsert(InsertStatement insertStatement, ShardingSphereSchema schema) {
        ShardingSphereTable table = schema.getTable(insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse(""));
        List<String> columnNamesOfInsert = MySQLComStmtPrepareParameterMarkerExtractor.getColumnNamesOfInsertStatement(insertStatement, table);
        List<ShardingSphereColumn> result = MySQLComStmtPrepareParameterMarkerExtractor.getParameterMarkerColumns(insertStatement, table, columnNamesOfInsert);
        insertStatement.getOnDuplicateKeyColumns().ifPresent(optional -> result.addAll(MySQLComStmtPrepareParameterMarkerExtractor.getOnDuplicateKeyParameterMarkerColumns(optional.getColumns(), table)));
        return result;
    }

    private static List<String> getColumnNamesOfInsertStatement(InsertStatement insertStatement, ShardingSphereTable table) {
        return insertStatement.getColumns().isEmpty() ? table.getColumnNames().stream().map(ShardingSphereIdentifier::getValue).collect(Collectors.toList()) : insertStatement.getColumns().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    private static List<ShardingSphereColumn> getParameterMarkerColumns(InsertStatement insertStatement, ShardingSphereTable table, List<String> columnNamesOfInsert) {
        ArrayList<ShardingSphereColumn> result = new ArrayList<ShardingSphereColumn>(insertStatement.getParameterMarkers().size());
        for (InsertValuesSegment each : insertStatement.getValues()) {
            result.addAll(MySQLComStmtPrepareParameterMarkerExtractor.getParameterMarkerColumns(table, columnNamesOfInsert, each));
        }
        return result;
    }

    private static List<ShardingSphereColumn> getParameterMarkerColumns(ShardingSphereTable table, List<String> columnNamesOfInsert, InsertValuesSegment segment) {
        LinkedList<ShardingSphereColumn> result = new LinkedList<ShardingSphereColumn>();
        int index = 0;
        for (ExpressionSegment each : segment.getValues()) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                String columnName = columnNamesOfInsert.get(index);
                ShardingSpherePreconditions.checkState((boolean)table.containsColumn(columnName), () -> new ColumnNotFoundException(table.getName(), columnName));
                result.add(table.getColumn(columnName));
            }
            ++index;
        }
        return result;
    }

    private static List<ShardingSphereColumn> getOnDuplicateKeyParameterMarkerColumns(Collection<ColumnAssignmentSegment> onDuplicateKeyColumns, ShardingSphereTable table) {
        LinkedList<ShardingSphereColumn> result = new LinkedList<ShardingSphereColumn>();
        for (ColumnAssignmentSegment each : onDuplicateKeyColumns) {
            if (!(each.getValue() instanceof ParameterMarkerExpressionSegment)) continue;
            String columnName = ((ColumnSegment)each.getColumns().iterator().next()).getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((boolean)table.containsColumn(columnName), () -> new ColumnNotFoundException(table.getName(), columnName));
            result.add(table.getColumn(columnName));
        }
        return result;
    }

    @Generated
    private MySQLComStmtPrepareParameterMarkerExtractor() {
    }
}

