/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.manager;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.DialectSystemSchemaManager;
import org.apache.shardingsphere.infra.util.directory.ClasspathResourceDirectoryReader;

public final class SystemSchemaManager {
    private static final Map<String, DialectSystemSchemaManager> DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP;
    private static final String COMMON = "common";

    public static boolean isSystemTable(String schema, String tableName) {
        return DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.entrySet().stream().anyMatch(entry -> ((DialectSystemSchemaManager)entry.getValue()).getTables(schema).contains(tableName));
    }

    public static boolean isSystemTable(String databaseType, String schema, String tableName) {
        return DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.containsKey(databaseType) && DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(databaseType).isSystemTable(schema, tableName) || DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.containsKey(COMMON) && DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(COMMON).isSystemTable(schema, tableName);
    }

    public static boolean isSystemTable(String databaseType, String schema, Collection<String> tableNames) {
        return DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.containsKey(databaseType) && DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(databaseType).isSystemTable(schema, tableNames) || DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.containsKey(COMMON) && DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(COMMON).isSystemTable(schema, tableNames);
    }

    public static Collection<String> getTables(String databaseType, String schema) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(databaseType).getTables(schema));
        result.addAll(DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(COMMON).getTables(schema));
        return result;
    }

    public static Collection<InputStream> getAllInputStreams(String databaseType, String schema) {
        LinkedList<InputStream> result = new LinkedList<InputStream>();
        result.addAll(DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(databaseType).getAllInputStreams(schema));
        result.addAll(DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.get(COMMON).getAllInputStreams(schema));
        return result;
    }

    @Generated
    private SystemSchemaManager() {
    }

    static {
        List resourceNames;
        try (Stream resourceNameStream = ClasspathResourceDirectoryReader.read((String)"schema");){
            resourceNames = resourceNameStream.filter(each -> each.endsWith(".yaml")).collect(Collectors.toList());
        }
        DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP = new CaseInsensitiveMap();
        for (String each2 : resourceNames) {
            CharSequence[] pathParts = each2.split("/");
            if (4 != pathParts.length) continue;
            String databaseType = pathParts[1];
            String schemaName = pathParts[2];
            String tableName = Strings.CS.removeEnd(pathParts[3], (CharSequence)".yaml");
            String resourcePath = String.join((CharSequence)"/", pathParts);
            DialectSystemSchemaManager dialectSystemSchemaManager = DATABASE_TYPE_AND_SYSTEM_SCHEMA_MANAGER_MAP.computeIfAbsent(databaseType, key -> new DialectSystemSchemaManager());
            dialectSystemSchemaManager.putTable(schemaName, tableName);
            dialectSystemSchemaManager.putResource(schemaName, resourcePath);
        }
    }
}

