/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.model;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.TableType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class ShardingSphereTable {
    private final String name;
    private final Map<ShardingSphereIdentifier, ShardingSphereColumn> columns;
    private final List<ShardingSphereIdentifier> columnNames = new ArrayList<ShardingSphereIdentifier>();
    private final List<String> primaryKeyColumns = new ArrayList<String>();
    private final List<String> visibleColumns = new ArrayList<String>();
    private final Map<String, Integer> visibleColumnAndIndexMap = new CaseInsensitiveMap();
    private final Map<ShardingSphereIdentifier, ShardingSphereIndex> indexes;
    private final Map<ShardingSphereIdentifier, ShardingSphereConstraint> constraints;
    private final TableType type;

    public ShardingSphereTable(String name, Collection<ShardingSphereColumn> columns, Collection<ShardingSphereIndex> indexes, Collection<ShardingSphereConstraint> constraints) {
        this(name, columns, indexes, constraints, TableType.TABLE);
    }

    public ShardingSphereTable(String name, Collection<ShardingSphereColumn> columns, Collection<ShardingSphereIndex> indexes, Collection<ShardingSphereConstraint> constraints, TableType type) {
        this.name = name;
        this.columns = this.createColumns(columns);
        this.indexes = this.createIndexes(indexes);
        this.constraints = this.createConstraints(constraints);
        this.type = type;
    }

    private Map<ShardingSphereIdentifier, ShardingSphereColumn> createColumns(Collection<ShardingSphereColumn> columns) {
        LinkedHashMap<ShardingSphereIdentifier, ShardingSphereColumn> result = new LinkedHashMap<ShardingSphereIdentifier, ShardingSphereColumn>(columns.size(), 1.0f);
        int index = 0;
        for (ShardingSphereColumn each : columns) {
            ShardingSphereIdentifier columnName = new ShardingSphereIdentifier(each.getName());
            if (result.containsKey(columnName)) continue;
            result.put(columnName, each);
            this.columnNames.add(columnName);
            if (each.isPrimaryKey()) {
                this.primaryKeyColumns.add(each.getName());
            }
            if (!each.isVisible()) continue;
            this.visibleColumns.add(each.getName());
            this.visibleColumnAndIndexMap.put(each.getName(), index++);
        }
        return result;
    }

    private Map<ShardingSphereIdentifier, ShardingSphereIndex> createIndexes(Collection<ShardingSphereIndex> indexes) {
        return indexes.stream().collect(Collectors.toMap(each -> new ShardingSphereIdentifier(each.getName()), each -> each, (oldValue, currentValue) -> currentValue, () -> new LinkedHashMap(indexes.size(), 1.0f)));
    }

    private Map<ShardingSphereIdentifier, ShardingSphereConstraint> createConstraints(Collection<ShardingSphereConstraint> constraints) {
        return constraints.stream().collect(Collectors.toMap(each -> new ShardingSphereIdentifier(each.getName()), each -> each, (oldValue, currentValue) -> currentValue, () -> new LinkedHashMap(constraints.size(), 1.0f)));
    }

    public boolean containsColumn(String columnName) {
        return null != columnName && this.columns.containsKey(new ShardingSphereIdentifier(columnName));
    }

    public ShardingSphereColumn getColumn(String columnName) {
        return this.columns.get(new ShardingSphereIdentifier(columnName));
    }

    public Collection<ShardingSphereColumn> getAllColumns() {
        return this.columns.values();
    }

    public Collection<String> findColumnNamesIfNotExistedFrom(Collection<String> columnNames) {
        if (columnNames.size() == this.columns.size()) {
            return Collections.emptyList();
        }
        LinkedHashSet<ShardingSphereIdentifier> result = new LinkedHashSet<ShardingSphereIdentifier>(this.columns.keySet());
        result.removeAll(columnNames.stream().map(ShardingSphereIdentifier::new).collect(Collectors.toSet()));
        return result.stream().map(ShardingSphereIdentifier::getValue).collect(Collectors.toList());
    }

    public boolean containsIndex(String indexName) {
        return null != indexName && this.indexes.containsKey(new ShardingSphereIdentifier(indexName));
    }

    public Collection<ShardingSphereIndex> getAllIndexes() {
        return this.indexes.values();
    }

    public void putIndex(ShardingSphereIndex index) {
        this.indexes.put(new ShardingSphereIdentifier(index.getName()), index);
    }

    public void removeIndex(String indexName) {
        this.indexes.remove(new ShardingSphereIdentifier(indexName));
    }

    public Collection<ShardingSphereConstraint> getAllConstraints() {
        return this.constraints.values();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<ShardingSphereIdentifier> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    @Generated
    public List<String> getVisibleColumns() {
        return this.visibleColumns;
    }

    @Generated
    public Map<String, Integer> getVisibleColumnAndIndexMap() {
        return this.visibleColumnAndIndexMap;
    }

    @Generated
    public TableType getType() {
        return this.type;
    }

    @Generated
    public String toString() {
        return "ShardingSphereTable(name=" + this.getName() + ", columns=" + this.columns + ", columnNames=" + this.getColumnNames() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ", visibleColumns=" + this.getVisibleColumns() + ", visibleColumnAndIndexMap=" + this.getVisibleColumnAndIndexMap() + ", indexes=" + this.indexes + ", constraints=" + this.constraints + ", type=" + this.getType() + ")";
    }
}

