/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SafeNumberOperationUtils;

public final class ShardingConditions {
    private final List<ShardingCondition> conditions;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule rule;
    private final boolean subqueryContainsShardingCondition;

    public ShardingConditions(List<ShardingCondition> conditions, SQLStatementContext sqlStatementContext, ShardingRule rule) {
        this.conditions = conditions;
        this.sqlStatementContext = sqlStatementContext;
        this.rule = rule;
        this.subqueryContainsShardingCondition = this.isSubqueryContainsShardingCondition(conditions, sqlStatementContext);
    }

    public boolean isAlwaysFalse() {
        if (this.conditions.isEmpty()) {
            return false;
        }
        for (ShardingCondition each : this.conditions) {
            if (each instanceof AlwaysFalseShardingCondition) continue;
            return false;
        }
        return true;
    }

    public void merge() {
        if (this.conditions.size() > 1) {
            LinkedList<ShardingCondition> result = new LinkedList<ShardingCondition>();
            result.add(this.conditions.remove(this.conditions.size() - 1));
            while (!this.conditions.isEmpty()) {
                this.findUniqueShardingCondition(result, this.conditions.remove(this.conditions.size() - 1)).ifPresent(result::add);
            }
            this.conditions.addAll(result);
        }
    }

    private Optional<ShardingCondition> findUniqueShardingCondition(Collection<ShardingCondition> conditions, ShardingCondition condition) {
        for (ShardingCondition each : conditions) {
            if (!this.isSameShardingCondition(this.rule, condition, each)) continue;
            return Optional.empty();
        }
        return Optional.of(condition);
    }

    public boolean isNeedMerge() {
        boolean selectContainsSubquery = this.sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)this.sqlStatementContext).isContainsSubquery();
        boolean insertSelectContainsSubquery = this.sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)this.sqlStatementContext).getInsertSelectContext() && ((InsertStatementContext)this.sqlStatementContext).getInsertSelectContext().getSelectStatementContext().isContainsSubquery();
        return (selectContainsSubquery || insertSelectContainsSubquery) && !this.rule.getShardingLogicTableNames(this.sqlStatementContext.getTablesContext().getTableNames()).isEmpty();
    }

    private boolean isSubqueryContainsShardingCondition(List<ShardingCondition> conditions, SQLStatementContext sqlStatementContext) {
        Collection<SelectStatement> selectStatements = this.getSelectStatements(sqlStatementContext);
        if (selectStatements.size() > 1) {
            HashMap<Integer, List> startIndexShardingConditions = new HashMap<Integer, List>(conditions.size(), 1.0f);
            for (ShardingCondition shardingCondition : conditions) {
                startIndexShardingConditions.computeIfAbsent(shardingCondition.getStartIndex(), unused -> new LinkedList()).add(shardingCondition);
            }
            for (SelectStatement selectStatement : selectStatements) {
                if (selectStatement.getFrom().isPresent() && selectStatement.getFrom().get() instanceof SubqueryTableSegment || selectStatement.getWhere().isPresent() && startIndexShardingConditions.containsKey(((WhereSegment)selectStatement.getWhere().get()).getExpr().getStartIndex())) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<SelectStatement> getSelectStatements(SQLStatementContext sqlStatementContext) {
        LinkedList<SelectStatement> result = new LinkedList<SelectStatement>();
        if (sqlStatementContext instanceof SelectStatementContext) {
            result.add(((SelectStatementContext)sqlStatementContext).getSqlStatement());
            for (SelectStatementContext each : ((SelectStatementContext)sqlStatementContext).getSubqueryContexts().values()) {
                result.add(each.getSqlStatement());
            }
        }
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            SelectStatementContext selectStatementContext = ((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext();
            result.add(selectStatementContext.getSqlStatement());
            for (SelectStatementContext each : selectStatementContext.getSubqueryContexts().values()) {
                result.add(each.getSqlStatement());
            }
        }
        return result;
    }

    public boolean isSameShardingCondition() {
        Collection<String> hintStrategyTables = this.findHintStrategyTables(this.sqlStatementContext);
        return 1 == hintStrategyTables.size() || this.subqueryContainsShardingCondition && 1 == this.conditions.size();
    }

    private boolean isSameShardingCondition(ShardingRule shardingRule, ShardingCondition shardingCondition1, ShardingCondition shardingCondition2) {
        if (shardingCondition1.getValues().size() != shardingCondition2.getValues().size()) {
            return false;
        }
        for (int i = 0; i < shardingCondition1.getValues().size(); ++i) {
            ShardingConditionValue shardingValue2;
            ShardingConditionValue shardingValue1 = shardingCondition1.getValues().get(i);
            if (this.isSameShardingConditionValue(shardingRule, shardingValue1, shardingValue2 = shardingCondition2.getValues().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameShardingCondition(ShardingConditionValue shardingValue1, ShardingConditionValue shardingValue2) {
        return shardingValue1.getTableName().equals(shardingValue2.getTableName()) && shardingValue1.getColumnName().equals(shardingValue2.getColumnName());
    }

    private Collection<String> findHintStrategyTables(SQLStatementContext sqlStatementContext) {
        HashSet<String> result = new HashSet<String>(sqlStatementContext.getTablesContext().getTableNames().size(), 1.0f);
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            boolean isTableHintStrategy;
            Optional<ShardingTable> shardingTable = this.rule.findShardingTable(each);
            if (!shardingTable.isPresent()) continue;
            ShardingStrategyConfiguration databaseHintStrategy = this.rule.getDatabaseShardingStrategyConfiguration(shardingTable.get());
            ShardingStrategyConfiguration tableHintStrategy = this.rule.getTableShardingStrategyConfiguration(shardingTable.get());
            boolean isDatabaseTableHintStrategy = databaseHintStrategy instanceof HintShardingStrategyConfiguration && tableHintStrategy instanceof HintShardingStrategyConfiguration;
            boolean isDatabaseHintStrategy = databaseHintStrategy instanceof HintShardingStrategyConfiguration && tableHintStrategy instanceof NoneShardingStrategyConfiguration;
            boolean bl = isTableHintStrategy = databaseHintStrategy instanceof NoneShardingStrategyConfiguration && tableHintStrategy instanceof HintShardingStrategyConfiguration;
            if (!isDatabaseTableHintStrategy && !isDatabaseHintStrategy && !isTableHintStrategy) continue;
            result.add(each);
        }
        return result;
    }

    private boolean isBindingTable(ShardingRule shardingRule, ShardingConditionValue shardingValue1, ShardingConditionValue shardingValue2) {
        Optional<BindingTableRule> bindingRule = shardingRule.findBindingTableRule(shardingValue1.getTableName());
        return bindingRule.isPresent() && !shardingValue1.getTableName().equals(shardingValue2.getTableName()) && bindingRule.get().hasLogicTable(shardingValue2.getTableName());
    }

    private boolean isSameShardingConditionValue(ShardingRule shardingRule, ShardingConditionValue shardingValue1, ShardingConditionValue shardingValue2) {
        if (this.isBindingTable(shardingRule, shardingValue1, shardingValue2)) {
            return true;
        }
        return this.isSameShardingCondition(shardingValue1, shardingValue2) && this.isSameShardingValue(shardingValue1, shardingValue2);
    }

    private boolean isSameShardingValue(ShardingConditionValue shardingConditionValue1, ShardingConditionValue shardingConditionValue2) {
        if (shardingConditionValue1 instanceof ListShardingConditionValue && shardingConditionValue2 instanceof ListShardingConditionValue) {
            return SafeNumberOperationUtils.safeCollectionEquals(((ListShardingConditionValue)shardingConditionValue1).getValues(), ((ListShardingConditionValue)shardingConditionValue2).getValues());
        }
        if (shardingConditionValue1 instanceof RangeShardingConditionValue && shardingConditionValue2 instanceof RangeShardingConditionValue) {
            return SafeNumberOperationUtils.safeRangeEquals(((RangeShardingConditionValue)shardingConditionValue1).getValueRange(), ((RangeShardingConditionValue)shardingConditionValue2).getValueRange());
        }
        return false;
    }

    @Generated
    public List<ShardingCondition> getConditions() {
        return this.conditions;
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public ShardingRule getRule() {
        return this.rule;
    }

    @Generated
    public boolean isSubqueryContainsShardingCondition() {
        return this.subqueryContainsShardingCondition;
    }

    @Generated
    public String toString() {
        return "ShardingConditions(conditions=" + this.getConditions() + ", sqlStatementContext=" + this.getSqlStatementContext() + ", rule=" + this.getRule() + ", subqueryContainsShardingCondition=" + this.isSubqueryContainsShardingCondition() + ")";
    }
}

