/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.dml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.engine.GeneratedKeyContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertSelectContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementBaseContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;

public final class InsertStatementBindingContext
implements SQLStatementContext {
    private final InsertStatementBaseContext baseContext;
    private final List<InsertValueContext> insertValueContexts;
    private final InsertSelectContext insertSelectContext;
    private final OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext;
    private final GeneratedKeyContext generatedKeyContext;

    public InsertStatementBindingContext(InsertStatementBaseContext baseContext, List<Object> params, ShardingSphereMetaData metaData, String currentDatabaseName) {
        this.baseContext = baseContext;
        AtomicInteger parametersOffset = new AtomicInteger(0);
        this.insertValueContexts = this.getInsertValueContexts(params, parametersOffset, baseContext.getValueExpressions());
        this.insertSelectContext = this.getInsertSelectContext(params, parametersOffset, metaData, currentDatabaseName).orElse(null);
        this.onDuplicateKeyUpdateValueContext = this.getOnDuplicateKeyUpdateValueContext(params, parametersOffset).orElse(null);
        this.generatedKeyContext = new GeneratedKeyContextEngine(baseContext.getSqlStatement(), baseContext.getSchema()).createGenerateKeyContext(baseContext.getInsertColumnNamesAndIndexes(), this.insertValueContexts, params).orElse(null);
    }

    private List<InsertValueContext> getInsertValueContexts(List<Object> params, AtomicInteger paramsOffset, List<List<ExpressionSegment>> valueExpressions) {
        LinkedList<InsertValueContext> result = new LinkedList<InsertValueContext>();
        for (Collection collection : valueExpressions) {
            InsertValueContext insertValueContext = new InsertValueContext(collection, params, paramsOffset.get());
            result.add(insertValueContext);
            paramsOffset.addAndGet(insertValueContext.getParameterCount());
        }
        return result;
    }

    private Optional<InsertSelectContext> getInsertSelectContext(List<Object> params, AtomicInteger paramsOffset, ShardingSphereMetaData metaData, String currentDatabaseName) {
        if (!this.baseContext.getSqlStatement().getInsertSelect().isPresent()) {
            return Optional.empty();
        }
        SubquerySegment insertSelectSegment = (SubquerySegment)this.baseContext.getSqlStatement().getInsertSelect().get();
        SelectStatementContext selectStatementContext = new SelectStatementContext(insertSelectSegment.getSelect(), metaData, currentDatabaseName, Collections.emptyList());
        selectStatementContext.bindParameters(params);
        selectStatementContext.setSubqueryType(SubqueryType.INSERT_SELECT);
        this.setCombineSelectSubqueryType(selectStatementContext);
        this.setProjectionSelectSubqueryType(selectStatementContext);
        InsertSelectContext insertSelectContext = new InsertSelectContext(selectStatementContext, params, paramsOffset.get());
        paramsOffset.addAndGet(insertSelectContext.getSelectStatementContext().getSqlStatement().getParameterCount());
        return Optional.of(insertSelectContext);
    }

    private void setCombineSelectSubqueryType(SelectStatementContext selectStatementContext) {
        if (selectStatementContext.getSqlStatement().getCombine().isPresent()) {
            CombineSegment combineSegment = (CombineSegment)selectStatementContext.getSqlStatement().getCombine().get();
            Optional.ofNullable(selectStatementContext.getSubqueryContexts().get(combineSegment.getLeft().getStartIndex())).ifPresent(optional -> optional.setSubqueryType(SubqueryType.INSERT_SELECT));
            Optional.ofNullable(selectStatementContext.getSubqueryContexts().get(combineSegment.getRight().getStartIndex())).ifPresent(optional -> optional.setSubqueryType(SubqueryType.INSERT_SELECT));
        }
    }

    private void setProjectionSelectSubqueryType(SelectStatementContext selectStatementContext) {
        for (Map.Entry<Integer, SelectStatementContext> entry : selectStatementContext.getSubqueryContexts().entrySet()) {
            if (entry.getKey() < selectStatementContext.getProjectionsContext().getStartIndex() || entry.getKey() > selectStatementContext.getProjectionsContext().getStopIndex()) continue;
            entry.getValue().setSubqueryType(SubqueryType.INSERT_SELECT);
        }
    }

    private Optional<OnDuplicateUpdateContext> getOnDuplicateKeyUpdateValueContext(List<Object> params, AtomicInteger parametersOffset) {
        Optional onDuplicateKeyColumnsSegment = this.baseContext.getSqlStatement().getOnDuplicateKeyColumns();
        if (!onDuplicateKeyColumnsSegment.isPresent()) {
            return Optional.empty();
        }
        Collection onDuplicateKeyColumns = ((OnDuplicateKeyColumnsSegment)onDuplicateKeyColumnsSegment.get()).getColumns();
        OnDuplicateUpdateContext onDuplicateUpdateContext = new OnDuplicateUpdateContext(onDuplicateKeyColumns, params, parametersOffset.get());
        parametersOffset.addAndGet(onDuplicateUpdateContext.getParameterCount());
        return Optional.of(onDuplicateUpdateContext);
    }

    public List<List<Object>> getGroupedParameters() {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (InsertValueContext each : this.insertValueContexts) {
            result.add(each.getParameters());
        }
        return result;
    }

    public List<Object> getOnDuplicateKeyUpdateParameters() {
        return null == this.onDuplicateKeyUpdateValueContext ? new ArrayList() : this.onDuplicateKeyUpdateValueContext.getParameters();
    }

    public Optional<GeneratedKeyContext> getGeneratedKeyContext() {
        return Optional.ofNullable(this.generatedKeyContext);
    }

    public InsertStatement getSqlStatement() {
        return this.baseContext.getSqlStatement();
    }

    @Override
    public TablesContext getTablesContext() {
        return this.baseContext.getTablesContext();
    }

    @Generated
    public List<InsertValueContext> getInsertValueContexts() {
        return this.insertValueContexts;
    }

    @Generated
    public InsertSelectContext getInsertSelectContext() {
        return this.insertSelectContext;
    }

    @Generated
    public OnDuplicateUpdateContext getOnDuplicateKeyUpdateValueContext() {
        return this.onDuplicateKeyUpdateValueContext;
    }
}

