/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.protocol;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public final class PostgreSQLArrayParameterDecoder {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public short[] decodeInt2Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        short[] result = new short[parameterElements.size()];
        int index = 0;
        for (String each : parameterElements) {
            result[index++] = Short.parseShort(each);
        }
        return result;
    }

    public int[] decodeInt4Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        int[] result = new int[parameterElements.size()];
        int index = 0;
        for (String each : parameterElements) {
            result[index++] = Integer.parseInt(each);
        }
        return result;
    }

    public long[] decodeInt8Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        long[] result = new long[parameterElements.size()];
        int index = 0;
        for (String each : parameterElements) {
            result[index++] = Long.parseLong(each);
        }
        return result;
    }

    public float[] decodeFloat4Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        float[] result = new float[parameterElements.size()];
        int index = 0;
        for (String each : parameterElements) {
            result[index++] = Float.parseFloat(each);
        }
        return result;
    }

    public double[] decodeFloat8Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        double[] result = new double[parameterElements.size()];
        int index = 0;
        for (String each : parameterElements) {
            result[index++] = Double.parseDouble(each);
        }
        return result;
    }

    public boolean[] decodeBoolArray(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        boolean[] result = new boolean[parameterElements.size()];
        int index = 0;
        for (String each : parameterElements) {
            result[index++] = Boolean.parseBoolean(each);
        }
        return result;
    }

    public String[] decodeStringArray(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        return parameterElements.toArray(EMPTY_STRING_ARRAY);
    }

    private Collection<String> decodeText(String value) {
        Preconditions.checkArgument((value.length() >= 2 ? 1 : 0) != 0, (Object)"value length less than 2");
        Preconditions.checkArgument(('{' == value.charAt(0) && '}' == value.charAt(value.length() - 1) ? 1 : 0) != 0, (Object)"value not start with '{' or not end with '}'");
        String[] elements = value.substring(1, value.length() - 1).split(",");
        return Arrays.stream(elements).map(each -> "NULL".equals(each) ? null : PostgreSQLArrayParameterDecoder.decodeElementText(each)).collect(Collectors.toList());
    }

    private static String decodeElementText(String element) {
        String result = element;
        if ('\"' == result.charAt(0) && '\"' == result.charAt(result.length() - 1)) {
            result = result.substring(1, result.length() - 1);
        }
        while (result.contains("\\\"")) {
            result = result.replace("\\\"", "\"");
        }
        while (result.contains("\\\\")) {
            result = result.replace("\\\\", "\\");
        }
        return result;
    }
}

