/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.identifier;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.exception.PostgreSQLProtocolException;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;

public enum PostgreSQLMessagePacketType implements PostgreSQLIdentifierTag
{
    AUTHENTICATION_REQUEST('R'),
    PARSE_COMPLETE('1'),
    BIND_COMPLETE('2'),
    COMMAND_COMPLETE('C'),
    ROW_DESCRIPTION('T'),
    DATA_ROW('D'),
    READY_FOR_QUERY('Z'),
    CLOSE_COMPLETE('3'),
    COPY_DATA('d'),
    COPY_COMPLETE('c'),
    COPY_FAILURE('f'),
    COPY_IN_RESPONSE('G'),
    COPY_OUT_RESPONSE('H'),
    COPY_BOTH_RESPONSE('W'),
    EMPTY_QUERY_RESPONSE('I'),
    ERROR_RESPONSE('E'),
    FUNCTION_CALL('F'),
    FUNCTION_CALL_RESPONSE('V'),
    GSS_RESPONSE('p'),
    NOTICE_RESPONSE('N'),
    NOTIFICATION_RESPONSE('A'),
    SASL_INITIAL_RESPONSE('p'),
    SASL_RESPONSE('p'),
    BACKEND_KEY_DATA('K'),
    NEGOTIATE_PROTOCOL_VERSION('v'),
    NO_DATA('n'),
    PARAMETER_DESCRIPTION('t'),
    PARAMETER_STATUS('S'),
    PASSWORD_MESSAGE('p'),
    PORTAL_SUSPENDED('s');

    private final char value;

    public static PostgreSQLMessagePacketType valueOf(int value) {
        for (PostgreSQLMessagePacketType each : PostgreSQLMessagePacketType.values()) {
            if (value != each.value) continue;
            return each;
        }
        throw new PostgreSQLProtocolException("Can not find `%s` in PostgreSQL identifier tag type.", value);
    }

    @Generated
    private PostgreSQLMessagePacketType(char value) {
        this.value = value;
    }

    @Override
    @Generated
    public char getValue() {
        return this.value;
    }
}

