/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;

public final class CaseWhenExpressionConverter {
    public static SqlCase convert(CaseWhenExpression segment) {
        Collection<SqlNode> whenExprs = CaseWhenExpressionConverter.convertWhenExprs(segment.getCaseExpr(), segment.getWhenExprs());
        LinkedList thenExprs = new LinkedList();
        segment.getThenExprs().forEach(each -> ExpressionConverter.convert(each).ifPresent(thenExprs::add));
        Optional<SqlNode> elseExpr = ExpressionConverter.convert(segment.getElseExpr());
        return new SqlCase(SqlParserPos.ZERO, null, new SqlNodeList(whenExprs, SqlParserPos.ZERO), new SqlNodeList(thenExprs, SqlParserPos.ZERO), elseExpr.orElseGet(() -> SqlLiteral.createCharString((String)"NULL", (SqlParserPos)SqlParserPos.ZERO)));
    }

    private static Collection<SqlNode> convertWhenExprs(ExpressionSegment caseExpr, Collection<ExpressionSegment> whenExprs) {
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        for (ExpressionSegment each : whenExprs) {
            if (null == caseExpr) {
                ExpressionConverter.convert(each).ifPresent(result::add);
                continue;
            }
            CaseWhenExpressionConverter.convertCaseExpr(caseExpr, each).ifPresent(result::add);
        }
        return result;
    }

    private static Optional<SqlNode> convertCaseExpr(ExpressionSegment caseExpr, ExpressionSegment whenExpr) {
        Optional<SqlNode> leftExpr = ExpressionConverter.convert(caseExpr);
        Optional<SqlNode> rightExpr = ExpressionConverter.convert(whenExpr);
        if (leftExpr.isPresent() && rightExpr.isPresent()) {
            return ExpressionConverter.convert(whenExpr).map(optional -> new SqlBasicCall((SqlOperator)SqlStdOperatorTable.EQUALS, Arrays.asList((SqlNode)leftExpr.get(), (SqlNode)rightExpr.get()), SqlParserPos.ZERO));
        }
        return Optional.empty();
    }

    @Generated
    private CaseWhenExpressionConverter() {
    }
}

