/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm.standard;

import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithmMetaData;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.apache.shardingsphere.infra.algorithm.cryptographic.spi.CryptographicAlgorithm;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.props.PropertiesBuilder;

public final class AESEncryptAlgorithm
implements EncryptAlgorithm {
    private static final String AES_KEY = "aes-key-value";
    private static final String DIGEST_ALGORITHM_NAME = "digest-algorithm-name";
    private final EncryptAlgorithmMetaData metaData = new EncryptAlgorithmMetaData(true, true, false);
    private Properties props;
    private CryptographicAlgorithm cryptographicAlgorithm;

    public void init(Properties props) {
        this.props = props;
        this.cryptographicAlgorithm = (CryptographicAlgorithm)TypedSPILoader.getService(CryptographicAlgorithm.class, (Object)this.getType(), (Properties)props);
    }

    public String encrypt(Object plainValue, AlgorithmSQLContext algorithmSQLContext) {
        Object result = this.cryptographicAlgorithm.encrypt(plainValue);
        return null == result ? null : String.valueOf(result);
    }

    public Object decrypt(Object cipherValue, AlgorithmSQLContext algorithmSQLContext) {
        return this.cryptographicAlgorithm.decrypt(cipherValue);
    }

    public AlgorithmConfiguration toConfiguration() {
        return new AlgorithmConfiguration(this.getType(), PropertiesBuilder.build((PropertiesBuilder.Property[])new PropertiesBuilder.Property[]{new PropertiesBuilder.Property(AES_KEY, (Object)this.props.getProperty(AES_KEY)), new PropertiesBuilder.Property(DIGEST_ALGORITHM_NAME, (Object)StringUtils.upperCase((String)this.props.getProperty(DIGEST_ALGORITHM_NAME)))}));
    }

    public String getType() {
        return "AES";
    }

    @Generated
    public EncryptAlgorithmMetaData getMetaData() {
        return this.metaData;
    }
}

