/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptTableNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.MismatchedEncryptAlgorithmTypeException;
import org.apache.shardingsphere.encrypt.rule.attribute.EncryptTableMapperRuleAttribute;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rule.PartialRuleUpdateSupported;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class EncryptRule
implements DatabaseRule,
PartialRuleUpdateSupported<EncryptRuleConfiguration> {
    private final String databaseName;
    private final AtomicReference<EncryptRuleConfiguration> ruleConfig = new AtomicReference();
    private final Map<String, EncryptAlgorithm> encryptors;
    private final Map<String, EncryptTable> tables = new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMap());
    private final AtomicReference<RuleAttributes> attributes = new AtomicReference();

    public EncryptRule(String databaseName, EncryptRuleConfiguration ruleConfig) {
        this.databaseName = databaseName;
        this.ruleConfig.set(ruleConfig);
        this.encryptors = this.createEncryptors(ruleConfig);
        for (EncryptTableRuleConfiguration each : ruleConfig.getTables()) {
            each.getColumns().forEach(this::checkEncryptorType);
            this.tables.put(each.getName(), new EncryptTable(each, this.encryptors));
        }
        this.attributes.set(this.buildRuleAttributes());
    }

    private RuleAttributes buildRuleAttributes() {
        LinkedList<EncryptTableMapperRuleAttribute> ruleAttributes = new LinkedList<EncryptTableMapperRuleAttribute>();
        ruleAttributes.add(new EncryptTableMapperRuleAttribute(this.tables.keySet()));
        return new RuleAttributes(ruleAttributes.toArray(new RuleAttribute[0]));
    }

    private Map<String, EncryptAlgorithm> createEncryptors(EncryptRuleConfiguration ruleConfig) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMap(ruleConfig.getEncryptors().size(), 1.0f));
        for (Map.Entry entry : ruleConfig.getEncryptors().entrySet()) {
            result.put((String)entry.getKey(), (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)((AlgorithmConfiguration)entry.getValue()).getType(), (Properties)((AlgorithmConfiguration)entry.getValue()).getProps()));
        }
        return result;
    }

    private void checkEncryptorType(EncryptColumnRuleConfiguration columnRuleConfig) {
        ShardingSpherePreconditions.checkState((this.encryptors.containsKey(columnRuleConfig.getCipher().getEncryptorName()) && this.encryptors.get(columnRuleConfig.getCipher().getEncryptorName()).getMetaData().isSupportDecrypt() ? 1 : 0) != 0, () -> new MismatchedEncryptAlgorithmTypeException(this.databaseName, "Cipher", columnRuleConfig.getCipher().getEncryptorName(), "decrypt"));
        columnRuleConfig.getAssistedQuery().ifPresent(optional -> ShardingSpherePreconditions.checkState((this.encryptors.containsKey(optional.getEncryptorName()) && this.encryptors.get(optional.getEncryptorName()).getMetaData().isSupportEquivalentFilter() ? 1 : 0) != 0, () -> new MismatchedEncryptAlgorithmTypeException(this.databaseName, "Assisted query", columnRuleConfig.getCipher().getEncryptorName(), "equivalent filter")));
        columnRuleConfig.getLikeQuery().ifPresent(optional -> ShardingSpherePreconditions.checkState((this.encryptors.containsKey(optional.getEncryptorName()) && this.encryptors.get(optional.getEncryptorName()).getMetaData().isSupportLike() ? 1 : 0) != 0, () -> new MismatchedEncryptAlgorithmTypeException(this.databaseName, "Like query", columnRuleConfig.getCipher().getEncryptorName(), "like")));
    }

    public Collection<String> getAllTableNames() {
        return this.tables.keySet();
    }

    public Optional<EncryptTable> findEncryptTable(String tableName) {
        return Optional.ofNullable(this.tables.get(tableName));
    }

    public EncryptTable getEncryptTable(String tableName) {
        return this.findEncryptTable(tableName).orElseThrow(() -> new EncryptTableNotFoundException(tableName));
    }

    public Optional<EncryptAlgorithm> findQueryEncryptor(String tableName, String columnName) {
        return this.findEncryptTable(tableName).flatMap(optional -> optional.findQueryEncryptor(columnName));
    }

    public RuleAttributes getAttributes() {
        return this.attributes.get();
    }

    public EncryptRuleConfiguration getConfiguration() {
        return this.ruleConfig.get();
    }

    public void updateConfiguration(EncryptRuleConfiguration toBeUpdatedRuleConfig) {
        this.ruleConfig.set(toBeUpdatedRuleConfig);
    }

    public boolean partialUpdate(EncryptRuleConfiguration toBeUpdatedRuleConfig) {
        if (this.handleAddedEncryptors(toBeUpdatedRuleConfig) || this.handleRemovedEncryptors(toBeUpdatedRuleConfig)) {
            return false;
        }
        Collection toBeUpdatedTablesNames = (Collection)toBeUpdatedRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toCollection(CaseInsensitiveSet::new));
        Collection toBeRemovedTableNames = this.tables.keySet().stream().filter(each -> !toBeUpdatedTablesNames.contains(each)).collect(Collectors.toList());
        if (!toBeRemovedTableNames.isEmpty()) {
            toBeRemovedTableNames.forEach(this.tables::remove);
        }
        for (EncryptTableRuleConfiguration encryptTableRuleConfiguration : toBeUpdatedRuleConfig.getTables()) {
            encryptTableRuleConfiguration.getColumns().forEach(this::checkEncryptorType);
            this.tables.put(encryptTableRuleConfiguration.getName(), new EncryptTable(encryptTableRuleConfiguration, this.encryptors));
            this.attributes.set(this.buildRuleAttributes());
        }
        return true;
    }

    private boolean handleAddedEncryptors(EncryptRuleConfiguration toBeUpdatedRuleConfig) {
        return toBeUpdatedRuleConfig.getEncryptors().entrySet().stream().filter(entry -> !this.encryptors.containsKey(entry.getKey())).peek(entry -> this.encryptors.computeIfAbsent((String)entry.getKey(), key -> (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)((AlgorithmConfiguration)entry.getValue()).getType(), (Properties)((AlgorithmConfiguration)entry.getValue()).getProps()))).findAny().isPresent();
    }

    private boolean handleRemovedEncryptors(EncryptRuleConfiguration toBeUpdatedRuleConfig) {
        return this.encryptors.entrySet().stream().filter(entry -> !toBeUpdatedRuleConfig.getEncryptors().containsKey(entry.getKey())).peek(entry -> this.encryptors.remove(entry.getKey())).findAny().isPresent();
    }

    public int getOrder() {
        return 10;
    }
}

