/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.generator;

import com.google.protobuf.Message;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.CDCResponse;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.DataRecordResult;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.ServerGreetingResult;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.StreamDataResult;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;

public final class CDCResponseUtils {
    public static CDCResponse succeed(String requestId) {
        return CDCResponseUtils.succeed(requestId, CDCResponse.ResponseCase.RESPONSE_NOT_SET, null);
    }

    public static CDCResponse succeed(String requestId, CDCResponse.ResponseCase responseCase, Message response) {
        CDCResponse.Builder result = CDCResponse.newBuilder().setStatus(CDCResponse.Status.SUCCEED).setRequestId(requestId);
        switch (responseCase) {
            case SERVER_GREETING_RESULT: {
                result.setServerGreetingResult((ServerGreetingResult)response);
                break;
            }
            case DATA_RECORD_RESULT: {
                result.setDataRecordResult((DataRecordResult)response);
                break;
            }
            case STREAM_DATA_RESULT: {
                result.setStreamDataResult((StreamDataResult)response);
                break;
            }
            case RESPONSE_NOT_SET: {
                break;
            }
            default: {
                throw new PipelineInvalidParameterException("Unknown response case: `" + responseCase.name() + "`.");
            }
        }
        return result.build();
    }

    public static CDCResponse failed(String requestId, String errorCode, String errorMessage) {
        return CDCResponse.newBuilder().setStatus(CDCResponse.Status.FAILED).setRequestId(requestId).setErrorCode(errorCode).setErrorMessage(errorMessage).build();
    }

    @Generated
    private CDCResponseUtils() {
    }
}

