/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload.FirebirdBlobUpload;

public final class FirebirdBlobUploadCache {
    private static final FirebirdBlobUploadCache INSTANCE = new FirebirdBlobUploadCache();
    private final Map<Integer, Map<Integer, FirebirdBlobUpload>> uploadsByHandle = new ConcurrentHashMap<Integer, Map<Integer, FirebirdBlobUpload>>(16);
    private final Map<Integer, Map<Long, FirebirdBlobUpload>> uploadsById = new ConcurrentHashMap<Integer, Map<Long, FirebirdBlobUpload>>(16);

    public static FirebirdBlobUploadCache getInstance() {
        return INSTANCE;
    }

    public void registerConnection(int connectionId) {
        this.uploadsByHandle.put(connectionId, new ConcurrentHashMap(4));
        this.uploadsById.put(connectionId, new ConcurrentHashMap(4));
    }

    public void unregisterConnection(int connectionId) {
        this.uploadsByHandle.remove(connectionId);
        this.uploadsById.remove(connectionId);
    }

    public void registerBlob(int connectionId, int blobHandle, long blobId) {
        FirebirdBlobUpload upload = new FirebirdBlobUpload(blobHandle, blobId);
        this.getHandleMap(connectionId).put(blobHandle, upload);
        this.getIdMap(connectionId).put(blobId, upload);
    }

    public OptionalInt appendSegment(int connectionId, int blobHandle, byte[] segment) {
        FirebirdBlobUpload upload = this.getHandleMap(connectionId).get(blobHandle);
        if (null == upload) {
            return OptionalInt.empty();
        }
        upload.append(segment);
        return OptionalInt.of(upload.getSize());
    }

    public OptionalInt closeUpload(int connectionId, int blobHandle) {
        FirebirdBlobUpload upload = this.getHandleMap(connectionId).get(blobHandle);
        if (null == upload) {
            return OptionalInt.empty();
        }
        upload.markClosed();
        return OptionalInt.of(upload.getSize());
    }

    public OptionalLong getBlobId(int connectionId, int blobHandle) {
        FirebirdBlobUpload upload = this.getHandleMap(connectionId).get(blobHandle);
        if (null == upload) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(upload.getBlobId());
    }

    public Optional<byte[]> getBlobData(int connectionId, long blobId) {
        FirebirdBlobUpload upload = this.getIdMap(connectionId).get(blobId);
        if (null == upload) {
            return Optional.empty();
        }
        return Optional.of(upload.getBytes());
    }

    public boolean isClosed(int connectionId, long blobId) {
        FirebirdBlobUpload upload = this.getIdMap(connectionId).get(blobId);
        return null != upload && upload.isClosed();
    }

    public void removeUpload(int connectionId, long blobId) {
        FirebirdBlobUpload upload = this.getIdMap(connectionId).remove(blobId);
        if (null != upload) {
            this.getHandleMap(connectionId).remove(upload.getBlobHandle());
        }
    }

    private Map<Integer, FirebirdBlobUpload> getHandleMap(int connectionId) {
        return this.uploadsByHandle.computeIfAbsent(connectionId, key -> new ConcurrentHashMap(4));
    }

    private Map<Long, FirebirdBlobUpload> getIdMap(int connectionId) {
        return this.uploadsById.computeIfAbsent(connectionId, key -> new ConcurrentHashMap(4));
    }

    @Generated
    private FirebirdBlobUploadCache() {
    }
}

