/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.free;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.FirebirdFreeStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.fetch.FirebirdFetchStatementCache;

public final class FirebirdFreeStatementCommandExecutor
implements CommandExecutor {
    private final FirebirdFreeStatementPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        switch (this.packet.getOption()) {
            case 2: 
            case 4: {
                this.connectionSession.getServerPreparedStatementRegistry().removePreparedStatement((Object)this.packet.getStatementId());
                break;
            }
            case 1: {
                this.connectionSession.getConnectionContext().clearCursorContext();
                ProxyBackendHandler proxyBackendHandler = FirebirdFetchStatementCache.getInstance().getFetchBackendHandler(this.connectionSession.getConnectionId(), this.packet.getStatementId());
                this.connectionSession.getDatabaseConnectionManager().unmarkResourceInUse(proxyBackendHandler);
                FirebirdFetchStatementCache.getInstance().unregisterStatement(this.connectionSession.getConnectionId(), this.packet.getStatementId());
                break;
            }
            default: {
                throw new FirebirdProtocolException("Unknown DSQL option type %d", new Object[]{this.packet.getOption()});
            }
        }
        return Collections.singleton(new FirebirdGenericResponsePacket());
    }

    @Generated
    public FirebirdFreeStatementCommandExecutor(FirebirdFreeStatementPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

